/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container.xa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.spi.AcknowledgeableMessageSink;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.StompletConfig;
import org.projectodd.stilts.stomplet.Subscriber;
import org.projectodd.stilts.stomplet.XAStomplet;
import org.projectodd.stilts.stomplet.container.SubscriberImpl;
import org.projectodd.stilts.stomplet.container.xa.PseudoXAStompletAcknowledgeableMessageSink;
import org.projectodd.stilts.stomplet.container.xa.PseudoXAStompletResourceManager;
import org.projectodd.stilts.stomplet.container.xa.PseudoXAStompletTransaction;

public class PseudoXAStomplet
implements XAStomplet {
    private Stomplet stomplet;
    private PseudoXAStompletResourceManager resourceManager;
    private Set<XAResource> xaResources;
    private Map<String, Subscriber> subscribers = new HashMap<String, Subscriber>();

    public PseudoXAStomplet(Stomplet stomplet) {
        this.stomplet = stomplet;
        this.resourceManager = new PseudoXAStompletResourceManager(stomplet);
        this.xaResources = new HashSet<XAResource>();
        this.xaResources.add(this.resourceManager);
    }

    public Set<XAResource> getXAResources() {
        return this.xaResources;
    }

    public void initialize(StompletConfig config) throws StompException {
        this.stomplet.initialize(config);
    }

    public void destroy() throws StompException {
        this.stomplet.destroy();
    }

    public void onMessage(StompMessage message, StompSession session) throws StompException {
        PseudoXAStompletTransaction tx = this.resourceManager.currentTransaction();
        if (tx == null) {
            this.stomplet.onMessage(message, session);
        } else {
            tx.addSentMessage(message, session);
        }
    }

    public void onSubscribe(Subscriber subscriber) throws StompException {
        String subscriberId = subscriber.getId();
        SubscriberImpl xaSubscriber = new SubscriberImpl(subscriber.getSession(), this.stomplet, subscriberId, subscriber.getDestination(), new PseudoXAStompletAcknowledgeableMessageSink(this.resourceManager, (AcknowledgeableMessageSink)subscriber), subscriber.getAckMode());
        this.subscribers.put(subscriberId, xaSubscriber);
        this.stomplet.onSubscribe((Subscriber)xaSubscriber);
    }

    public void onUnsubscribe(Subscriber subscriber) throws StompException {
        Subscriber xaSubscriber = this.subscribers.remove(subscriber.getId());
        if (xaSubscriber != null) {
            this.stomplet.onUnsubscribe(xaSubscriber);
        }
    }
}

