/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container.xa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.container.xa.PseudoXAStompletTransaction;

public class PseudoXAStompletResourceManager
implements XAResource {
    private static final Logger log = Logger.getLogger(PseudoXAStompletResourceManager.class);
    private final ThreadLocal<PseudoXAStompletTransaction> currentTransaction = new ThreadLocal();
    private final Map<Xid, PseudoXAStompletTransaction> transactions = new ConcurrentHashMap<Xid, PseudoXAStompletTransaction>();
    private Stomplet stomplet;
    private int transactionTimeout;

    public PseudoXAStompletResourceManager(Stomplet stomplet) {
        this.stomplet = stomplet;
    }

    public Stomplet getStomplet() {
        return this.stomplet;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.transactionTimeout = seconds;
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        log.tracef("start(%s, %s)", (Object)xid, (Object)flags);
        PseudoXAStompletTransaction tx = null;
        if (flags == 0 || flags == 0x200000) {
            tx = new PseudoXAStompletTransaction(this.stomplet);
            this.transactions.put(xid, tx);
        } else if (flags == 0x8000000) {
            tx = this.transactions.get(xid);
        }
        if (tx == null) {
            throw new XAException("Unable to start transaction: " + xid);
        }
        this.currentTransaction.set(tx);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        log.tracef("end(%s, %s)", (Object)xid, (Object)flags);
        PseudoXAStompletTransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        if (flags == 0x20000000) {
            tx.setRollbackOnly(true);
        }
        this.currentTransaction.remove();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        log.tracef("prepare(%s)", (Object)xid);
        PseudoXAStompletTransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        if (tx.isRollbackOnly()) {
            throw new XAException(100);
        }
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.tracef("commit(%s, %s)", (Object)xid, (Object)onePhase);
        PseudoXAStompletTransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        tx.commit();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        log.tracef("rollback(%s)", (Object)xid);
        PseudoXAStompletTransaction tx = this.transactions.get(xid);
        if (tx == null) {
            throw new XAException("No such transaction: " + xid);
        }
        tx.rollback();
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.tracef("forget(%s)", (Object)xid);
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public PseudoXAStompletTransaction currentTransaction() {
        return this.currentTransaction.get();
    }
}

