/*
 * Decompiled with CFR 0.152.
 */
package org.purejava.appindicator;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.purejava.appindicator.app_indicator_h;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(AppIndicator.class);
    private static boolean isLoaded = false;
    private static boolean ayatana = false;
    private static boolean appindicator = false;
    private static final String LD_CONFIG = "/etc/ld.so.conf.d/";
    private static final String APPINDICATOR_VERSION = "libappindicator3.so.1";
    private static final String FLATPAK_APPINDICATOR_VERSION = "libappindicator3.so";
    private static final String AYATANA_APPINDICATOR_VERSION = "libayatana-appindicator3.so.1";
    private static final String AYATANA_APPINDICATOR_LIBNAME_VERSION = "ayatana-appindicator3";
    private static final String APPINDICATOR_LIBNAME_VERSION = "appindicator3";
    private static List<String> allPath = new LinkedList<String>();

    public static MemorySegment newIndicator(String id, String iconName, int category) {
        if (null != id && null != iconName) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment memorySegment = app_indicator_h.app_indicator_new(arena.allocateFrom(id), arena.allocateFrom(iconName), category);
                return memorySegment;
            }
        }
        return MemorySegment.NULL;
    }

    public static MemorySegment newIndicatorWithPath(String id, String iconName, int category, String iconThemePath) {
        if (null != id && null != iconName && null != iconThemePath) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment memorySegment = app_indicator_h.app_indicator_new_with_path(arena.allocateFrom(id), arena.allocateFrom(iconName), category, arena.allocateFrom(iconThemePath));
                return memorySegment;
            }
        }
        return MemorySegment.NULL;
    }

    public static void buildMenuFromDesktop(MemorySegment self, String desktopFile, String desktopProfile) {
        if (null != self && null != desktopFile && null != desktopProfile) {
            try (Arena arena = Arena.ofConfined();){
                app_indicator_h.app_indicator_build_menu_from_desktop(self, arena.allocateFrom(desktopFile), arena.allocateFrom(desktopProfile));
            }
        }
    }

    public static int getCategory(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_category(self) : -1;
    }

    public static String getAttentionIcon(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_attention_icon(self).getString(0L) : "";
    }

    public static String getID(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_id(self).getString(0L) : "";
    }

    public static String getIcon(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_icon(self).getString(0L) : "";
    }

    public static String getLabel(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_label(self).getString(0L) : "";
    }

    public static MemorySegment getMenu(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_menu(self) : MemorySegment.NULL;
    }

    public static int getOrderingIndex(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_ordering_index(self) : 0;
    }

    public static int getStatus(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_status(self) : -1;
    }

    public static String getTitle(MemorySegment self) {
        return null != self ? app_indicator_h.app_indicator_get_title(self).getString(0L) : "";
    }

    public static void setAttentionIcon(MemorySegment self, String iconName) {
        if (null != self && null != iconName) {
            try (Arena arena = Arena.ofConfined();){
                app_indicator_h.app_indicator_set_attention_icon(self, arena.allocateFrom(iconName));
            }
        }
    }

    public static void setIcon(MemorySegment self, String iconName) {
        if (null != self && null != iconName) {
            try (Arena arena = Arena.ofConfined();){
                app_indicator_h.app_indicator_set_icon(self, arena.allocateFrom(iconName));
            }
        }
    }

    public static void setLabel(MemorySegment self, String label, String guide) {
        if (null != self && null != label && null != guide) {
            try (Arena arena = Arena.ofConfined();){
                app_indicator_h.app_indicator_set_label(self, arena.allocateFrom(label), arena.allocateFrom(guide));
            }
        }
    }

    public static void setMenu(MemorySegment self, MemorySegment menu) {
        if (null != self && null != menu) {
            app_indicator_h.app_indicator_set_menu(self, menu);
        }
    }

    public static void setOrderingIndex(MemorySegment self, int orderingIndex) {
        if (null != self) {
            app_indicator_h.app_indicator_set_ordering_index(self, orderingIndex);
        }
    }

    public static void setStatus(MemorySegment self, int status) {
        if (null != self) {
            app_indicator_h.app_indicator_set_status(self, status);
        }
    }

    public static void setTitle(MemorySegment self, String title) {
        if (null != self) {
            try (Arena arena = Arena.ofConfined();){
                app_indicator_h.app_indicator_set_title(self, arena.allocateFrom(title));
            }
        }
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    static {
        try (Stream<Path> paths = Files.list(Path.of(LD_CONFIG, new String[0]));){
            paths.forEach(file -> {
                try (Stream<String> lines = Files.lines(file);){
                    List<String> collection = lines.filter(line -> line.startsWith("/")).toList();
                    allPath.addAll(collection);
                }
                catch (IOException e) {
                    LOG.error("File '{}' could not be loaded", file);
                }
            });
        }
        catch (IOException e) {
            LOG.error("Directory '{}' does not exist", (Object)LD_CONFIG);
        }
        allPath.add("/usr/lib");
        allPath.add("/app/lib");
        allPath.add("/usr/lib64");
        for (String path : allPath) {
            try {
                System.load(path + File.separator + AYATANA_APPINDICATOR_VERSION);
                isLoaded = true;
                ayatana = true;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    if (!path.equals("/app/lib")) {
                        System.load(path + File.separator + APPINDICATOR_VERSION);
                    } else {
                        System.load(path + File.separator + FLATPAK_APPINDICATOR_VERSION);
                    }
                    isLoaded = true;
                    appindicator = true;
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                }
            }
        }
        if (!isLoaded) {
            try {
                System.loadLibrary(AYATANA_APPINDICATOR_LIBNAME_VERSION);
                isLoaded = true;
                ayatana = true;
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    System.loadLibrary(APPINDICATOR_LIBNAME_VERSION);
                    isLoaded = true;
                    appindicator = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
        }
        LOG.info(ayatana ? "Native code library libayatana-appindicator3.so.1 successfully loaded" : "Native code library libayatana-appindicator3.so.1 failed to load");
        LOG.info(appindicator ? "Native code library libappindicator3 successfully loaded" : "Native code library libappindicator3 failed to load");
    }
}

