/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;
import org.terracotta.quartz.TerracottaJobStoreExtensions;
import org.terracotta.quartz.TerracottaToolkitBuilder;
import org.terracotta.toolkit.internal.ToolkitInternal;

public abstract class AbstractTerracottaJobStore
implements JobStore {
    public static final String TC_CONFIG_PROP = "org.quartz.jobStore.tcConfig";
    public static final String TC_CONFIGURL_PROP = "org.quartz.jobStore.tcConfigUrl";
    private volatile ToolkitInternal toolkit;
    private volatile TerracottaJobStoreExtensions realJobStore;
    private String tcConfig = null;
    private String tcConfigUrl = null;
    private String schedInstId = null;
    private String schedName = null;
    private Long misFireThreshold = null;
    private String synchWrite = null;
    private Long estimatedTimeToReleaseAndAcquireTrigger = null;

    private void init() throws SchedulerConfigException {
        if (this.realJobStore != null) {
            return;
        }
        if (this.tcConfig != null && this.tcConfigUrl != null) {
            throw new SchedulerConfigException("Both org.quartz.jobStore.tcConfig and org.quartz.jobStore.tcConfigUrl are set in your properties. Please define only one of them");
        }
        if (this.tcConfig == null && this.tcConfigUrl == null) {
            throw new SchedulerConfigException("Neither org.quartz.jobStore.tcConfig or org.quartz.jobStore.tcConfigUrl are set in your properties. Please define one of them");
        }
        boolean isURLConfig = this.tcConfig == null;
        TerracottaToolkitBuilder toolkitBuilder = new TerracottaToolkitBuilder();
        if (isURLConfig) {
            toolkitBuilder.setTCConfigUrl(this.tcConfigUrl);
        } else {
            toolkitBuilder.setTCConfigSnippet(this.tcConfig);
        }
        toolkitBuilder.addTunnelledMBeanDomain("quartz");
        this.toolkit = (ToolkitInternal)toolkitBuilder.buildToolkit();
        try {
            this.realJobStore = this.getRealStore(this.toolkit);
        }
        catch (Exception e) {
            throw new SchedulerConfigException("Unable to create Terracotta client", e);
        }
    }

    abstract TerracottaJobStoreExtensions getRealStore(ToolkitInternal var1);

    public String getUUID() {
        if (this.realJobStore == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.realJobStore.getUUID();
    }

    public void setMisfireThreshold(long threshold) {
        this.misFireThreshold = threshold;
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        return this.realJobStore.acquireNextTriggers(noLaterThan, maxCount, timeWindow);
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        return this.realJobStore.getCalendarNames();
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        return this.realJobStore.getJobGroupNames();
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.realJobStore.getJobKeys(matcher);
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.realJobStore.getNumberOfCalendars();
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        return this.realJobStore.getNumberOfJobs();
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        return this.realJobStore.getNumberOfTriggers();
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return this.realJobStore.getPausedTriggerGroups();
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return this.realJobStore.getTriggerGroupNames();
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.realJobStore.getTriggerKeys(matcher);
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        return this.realJobStore.getTriggersForJob(jobKey);
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        return this.realJobStore.getTriggerState(triggerKey);
    }

    @Override
    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.init();
        this.realJobStore.setInstanceId(this.schedInstId);
        this.realJobStore.setInstanceName(this.schedName);
        if (this.misFireThreshold != null) {
            this.realJobStore.setMisfireThreshold(this.misFireThreshold);
        }
        if (this.synchWrite != null) {
            this.realJobStore.setSynchronousWrite(this.synchWrite);
        }
        if (this.estimatedTimeToReleaseAndAcquireTrigger != null) {
            this.realJobStore.setEstimatedTimeToReleaseAndAcquireTrigger(this.estimatedTimeToReleaseAndAcquireTrigger);
        }
        this.realJobStore.initialize(loadHelper, signaler);
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
        this.realJobStore.pauseAll();
    }

    @Override
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        this.realJobStore.pauseJob(jobKey);
    }

    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.realJobStore.pauseJobs(matcher);
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.realJobStore.pauseTrigger(triggerKey);
    }

    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.realJobStore.pauseTriggers(matcher);
    }

    @Override
    public void releaseAcquiredTrigger(OperableTrigger trigger) throws JobPersistenceException {
        this.realJobStore.releaseAcquiredTrigger(trigger);
    }

    @Override
    public boolean removeCalendar(String calName) throws JobPersistenceException {
        return this.realJobStore.removeCalendar(calName);
    }

    @Override
    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        return this.realJobStore.removeJob(jobKey);
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.realJobStore.removeTrigger(triggerKey);
    }

    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        return this.realJobStore.replaceTrigger(triggerKey, newTrigger);
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
        this.realJobStore.resumeAll();
    }

    @Override
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        this.realJobStore.resumeJob(jobKey);
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        return this.realJobStore.resumeJobs(matcher);
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.realJobStore.resumeTrigger(triggerKey);
    }

    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        return this.realJobStore.resumeTriggers(matcher);
    }

    @Override
    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        return this.realJobStore.retrieveCalendar(calName);
    }

    @Override
    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        return this.realJobStore.retrieveJob(jobKey);
    }

    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.realJobStore.retrieveTrigger(triggerKey);
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
        this.realJobStore.schedulerStarted();
    }

    @Override
    public void schedulerPaused() {
        this.realJobStore.schedulerPaused();
    }

    @Override
    public void schedulerResumed() {
        this.realJobStore.schedulerResumed();
    }

    @Override
    public void setInstanceId(String schedInstId) {
        this.schedInstId = schedInstId;
    }

    @Override
    public void setInstanceName(String schedName) {
        this.schedName = schedName;
    }

    @Override
    public void setThreadPoolSize(int poolSize) {
        this.realJobStore.setThreadPoolSize(poolSize);
    }

    @Override
    public void shutdown() {
        if (this.realJobStore != null) {
            this.realJobStore.shutdown();
        }
        if (this.toolkit != null) {
            this.toolkit.shutdown();
        }
    }

    @Override
    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.realJobStore.storeCalendar(name, calendar, replaceExisting, updateTriggers);
    }

    @Override
    public void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.realJobStore.storeJob(newJob, replaceExisting);
    }

    @Override
    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.realJobStore.storeJobAndTrigger(newJob, newTrigger);
    }

    @Override
    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.realJobStore.storeTrigger(newTrigger, replaceExisting);
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    @Override
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction instruction) throws JobPersistenceException {
        this.realJobStore.triggeredJobComplete(trigger, jobDetail, instruction);
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) throws JobPersistenceException {
        return this.realJobStore.triggersFired(triggers);
    }

    public void setTcConfig(String tcConfig) {
        this.tcConfig = tcConfig.trim();
    }

    public void setTcConfigUrl(String tcConfigUrl) {
        this.tcConfigUrl = tcConfigUrl.trim();
    }

    public void setSynchronousWrite(String synchWrite) {
        this.synchWrite = synchWrite;
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return this.realJobStore.getEstimatedTimeToReleaseAndAcquireTrigger();
    }

    public void setEstimatedTimeToReleaseAndAcquireTrigger(long estimate) {
        this.estimatedTimeToReleaseAndAcquireTrigger = estimate;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.realJobStore.checkExists(jobKey);
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.realJobStore.checkExists(triggerKey);
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        this.realJobStore.clearAllSchedulingData();
    }

    @Override
    public boolean removeTriggers(List<TriggerKey> arg0) throws JobPersistenceException {
        return this.realJobStore.removeTriggers(arg0);
    }

    @Override
    public boolean removeJobs(List<JobKey> arg0) throws JobPersistenceException {
        return this.realJobStore.removeJobs(arg0);
    }

    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> arg0, boolean arg1) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.realJobStore.storeJobsAndTriggers(arg0, arg1);
    }

    protected TerracottaJobStoreExtensions getRealJobStore() {
        return this.realJobStore;
    }
}

