/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension.resources;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import org.raml.jaxrs.generator.extension.resources.api.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceContext;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;

public class SimpleResponseObjectExtension
implements GlobalResourceExtension {
    private final List<String> arguments;

    public SimpleResponseObjectExtension(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public TypeSpec.Builder onResource(ResourceContext context, GResource resource, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, final GMethod method, GRequest gRequest, MethodSpec.Builder methodSpec) {
        if (method.responses().size() == 0) {
            return methodSpec.returns(Void.class);
        }
        methodSpec.addParameter(ParameterSpec.builder((TypeName)ClassName.get(HttpServletResponse.class), (String)"httpServletResponse", (Modifier[])new Modifier[0]).addAnnotation(Context.class).build());
        Optional responseOptional = FluentIterable.from(method.responses()).firstMatch(this.findByCode("200"));
        GResponse response = (GResponse)responseOptional.or((Supplier)new Supplier<GResponse>(){

            public GResponse get() {
                return (GResponse)FluentIterable.from(method.responses()).firstMatch(SimpleResponseObjectExtension.this.findByCode("201")).orNull();
            }
        });
        if (response == null) {
            methodSpec.returns((TypeName)ClassName.get(Void.class));
        } else {
            if (response.body().size() == 0) {
                return methodSpec.returns(Void.class);
            }
            methodSpec.returns(response.body().get(0).type().defaultJavaTypeName(context.getModelPackage()));
        }
        return methodSpec;
    }

    private Predicate<GResponse> findByCode(final String code) {
        return new Predicate<GResponse>(){

            public boolean apply(@Nullable GResponse gResponse) {
                return code.equals(gResponse.code());
            }
        };
    }

    @Override
    public TypeSpec.Builder onResponseClass(ResourceContext context, GMethod method, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GResponse responseMethod, MethodSpec.Builder methodSpec) {
        return methodSpec;
    }
}

