/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.HashSet;
import org.raml.v2.internal.impl.commons.nodes.BodyNode;
import org.raml.v2.internal.impl.commons.nodes.OverridableNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.yagi.framework.grammar.rule.RegexValueRule;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNode;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypesTraitsMerger {
    private static final Logger logger = LoggerFactory.getLogger(ResourceTypesTraitsMerger.class);

    static void merge(Node baseNode, Node copyNode) {
        if (copyNode instanceof NullNode) {
            return;
        }
        if (baseNode instanceof ObjectNode && copyNode instanceof ObjectNode) {
            ResourceTypesTraitsMerger.merge((ObjectNode)baseNode, (ObjectNode)copyNode);
        } else if (baseNode instanceof ArrayNode && copyNode instanceof ArrayNode) {
            ResourceTypesTraitsMerger.merge((ArrayNode)baseNode, (ArrayNode)copyNode);
        } else if (baseNode instanceof NullNode || copyNode instanceof ErrorNode) {
            baseNode.replaceWith(copyNode);
        } else {
            throw new RuntimeException(String.format("Merging not supported for nodes of type %s and %s", baseNode.getClass().getSimpleName(), copyNode.getClass().getSimpleName()));
        }
    }

    static void merge(ArrayNode baseNode, ArrayNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            baseNode.addChild(child);
        }
    }

    static void merge(ObjectNode baseNode, ObjectNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            if (child instanceof ErrorNode) {
                logger.debug("Adding ErrorNode");
                baseNode.addChild(child);
                continue;
            }
            if (!(child instanceof KeyValueNode)) {
                throw new RuntimeException("Only expecting KeyValueNode and got " + child.getClass());
            }
            String key = ((KeyValueNode)child).getKey().toString();
            if (ResourceTypesTraitsMerger.shouldIgnoreKey((KeyValueNode)child)) {
                logger.debug("Ignoring key '{}'", (Object)key);
                continue;
            }
            boolean optional = key.endsWith("?");
            if (optional) {
                key = key.substring(0, key.length() - 1);
            }
            Node node = NodeSelector.selectFrom((String)NodeSelector.encodePath((String)key), (Node)baseNode);
            Node childValue = ((KeyValueNode)child).getValue();
            if (node == null) {
                RegexValueRule mimeTypeRegex = new Raml10Grammar().mimeTypeRegex();
                if (baseNode.getParent() instanceof BodyNode && !mimeTypeRegex.matches(((KeyValueNode)child).getKey())) {
                    KeyValueNode mimeTypeNode;
                    if (baseNode.getChildren().size() <= 0 || !(baseNode.getChildren().get(0) instanceof KeyValueNode) || !mimeTypeRegex.matches((mimeTypeNode = (KeyValueNode)baseNode.getChildren().get(0)).getKey())) continue;
                    logger.debug("Overriding keys under the media type '{}'", (Object)copyNode);
                    ResourceTypesTraitsMerger.merge(mimeTypeNode.getValue(), (Node)copyNode);
                    continue;
                }
                logger.debug("Adding key '{}'", (Object)key);
                baseNode.addChild(child);
                continue;
            }
            if (childValue instanceof SimpleTypeNode) {
                if (DefaultPosition.isDefaultNode((Node)node) && !DefaultPosition.isDefaultNode((Node)childValue)) {
                    logger.debug("Overriding default key '{}'", (Object)key);
                    node.getParent().setChild(1, childValue);
                    continue;
                }
                if (node instanceof OverridableNode) {
                    logger.debug("Overriding scalar key '{}'", (Object)key);
                    node.getParent().setChild(1, childValue);
                    continue;
                }
                logger.debug("Scalar key already exists '{}'", (Object)key);
                continue;
            }
            logger.debug("Merging values '{}' and '{}'", (Object)node.getParent(), (Object)child);
            ResourceTypesTraitsMerger.merge(node, childValue);
        }
    }

    private static boolean shouldIgnoreKey(KeyValueNode child) {
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("usage");
        if (!(child.getParent() instanceof TypeDeclarationNode)) {
            ignoreSet.add("type");
        }
        String key = child.getKey().toString();
        return ignoreSet.contains(key);
    }
}

