/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.nodes.factory;

import java.text.StringCharacterIterator;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.NodeReferenceFactory;
import org.raml.v2.internal.impl.v10.nodes.ArrayTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.NamedTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.NativeTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.UnionTypeExpressionNode;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.NodeFactory;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.Position;

public class TypeExpressionReferenceFactory
implements NodeFactory {
    public Node create(@Nonnull Node currentNode, Object ... args) {
        String expression = ((String)args[0]).trim();
        try {
            return this.parse(currentNode, new StringCharacterIterator(expression), 0);
        }
        catch (TypeExpressionParsingException e) {
            return ErrorNodeFactory.createInvalidTypeExpressionSyntax((String)e.getMessage(), (String)expression, (int)e.getLocation());
        }
    }

    public TypeExpressionNode parse(Node currentNode, StringCharacterIterator iter, int depth) throws TypeExpressionParsingException {
        Stack<TypeExpressionNode> expressionStack = new Stack<TypeExpressionNode>();
        StringBuilder simpleExpression = new StringBuilder();
        char c = iter.current();
        while (c != '\uffff') {
            switch (c) {
                case '(': {
                    iter.next();
                    expressionStack.push(this.parse(currentNode, iter, depth + 1));
                    break;
                }
                case ')': {
                    return this.handleExpressionFinished(currentNode, expressionStack, iter, simpleExpression);
                }
                case '|': {
                    this.handleSimpleExpression(currentNode, iter, expressionStack, simpleExpression);
                    if (expressionStack.isEmpty()) {
                        throw new TypeExpressionParsingException("Expecting a type expression before |.", iter.getIndex());
                    }
                    TypeExpressionNode pop = expressionStack.pop();
                    if (expressionStack.isEmpty() || !(expressionStack.peek() instanceof UnionTypeExpressionNode)) {
                        expressionStack.push(new UnionTypeExpressionNode());
                    }
                    expressionStack.peek().addChild(pop);
                    break;
                }
                case '[': {
                    this.handleSimpleExpression(currentNode, iter, expressionStack, simpleExpression);
                    if (expressionStack.isEmpty()) {
                        throw new TypeExpressionParsingException("Expecting a type expression before [.", iter.getIndex());
                    }
                    if (iter.next() != ']') {
                        throw new TypeExpressionParsingException("Invalid character '" + iter.current() + "' expecting ']'.", iter.getIndex());
                    }
                    TypeExpressionNode arrayType = this.validateNode(expressionStack.pop(), iter);
                    ArrayTypeExpressionNode arrayTypeTypeNode = new ArrayTypeExpressionNode(arrayType);
                    arrayTypeTypeNode.setStartPosition(arrayType.getStartPosition());
                    arrayTypeTypeNode.setEndPosition(arrayType.getEndPosition().rightShift(2));
                    expressionStack.push(arrayTypeTypeNode);
                    break;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    simpleExpression.append(c);
                }
            }
            c = iter.next();
        }
        if (depth > 0) {
            throw new TypeExpressionParsingException("Parenthesis are not correctly balanced.", iter.getIndex());
        }
        return this.handleExpressionFinished(currentNode, expressionStack, iter, simpleExpression);
    }

    private TypeExpressionNode handleExpressionFinished(Node currentNode, Stack<TypeExpressionNode> typeStack, StringCharacterIterator iter, StringBuilder simpleExpression) throws TypeExpressionParsingException {
        this.handleSimpleExpression(currentNode, iter, typeStack, simpleExpression);
        TypeExpressionNode result = null;
        if (typeStack.isEmpty()) {
            throw new TypeExpressionParsingException("Invalid empty expression.", iter.getIndex());
        }
        while (!typeStack.isEmpty()) {
            TypeExpressionNode node = typeStack.pop();
            if (result != null) {
                node.addChild(result);
            }
            result = node;
            this.validateNode(result, iter);
        }
        return result;
    }

    private TypeExpressionNode validateNode(TypeExpressionNode result, StringCharacterIterator iter) throws TypeExpressionParsingException {
        if (result instanceof UnionTypeExpressionNode) {
            if (result.getChildren().size() < 2) {
                throw new TypeExpressionParsingException("Invalid union type expression.", iter.getIndex());
            }
        } else if (result instanceof ArrayTypeExpressionNode && result.getChildren().size() != 1) {
            throw new TypeExpressionParsingException("Invalid array type expression.", iter.getIndex());
        }
        return result;
    }

    private void handleSimpleExpression(Node currentNode, StringCharacterIterator iter, Stack<TypeExpressionNode> expressions, StringBuilder simpleExpression) throws TypeExpressionParsingException {
        String expressionString = simpleExpression.toString();
        boolean optionalType = false;
        if (expressionString.endsWith("?")) {
            expressionString = expressionString.substring(0, expressionString.length() - 1);
            optionalType = true;
        }
        Position startPosition = currentNode.getStartPosition().rightShift(iter.getIndex() - expressionString.length());
        Position endPosition = currentNode.getStartPosition().rightShift(iter.getIndex());
        if (NativeTypeExpressionNode.isNativeType(expressionString)) {
            NativeTypeExpressionNode item = new NativeTypeExpressionNode(expressionString);
            item.setStartPosition(startPosition);
            item.setEndPosition(endPosition);
            expressions.push(item);
            if (optionalType) {
                this.handleOptionalType(expressions);
            }
        } else if (expressionString.length() > 0) {
            NodeReferenceFactory nodeReferenceFactory = new NodeReferenceFactory(NamedTypeExpressionNode.class);
            Node parse = nodeReferenceFactory.parse(currentNode, expressionString, iter.getIndex());
            if (parse instanceof ErrorNode) {
                throw new TypeExpressionParsingException(((ErrorNode)parse).getErrorMessage(), currentNode.getStartPosition().getIndex());
            }
            expressions.push((TypeExpressionNode)parse);
            if (optionalType) {
                this.handleOptionalType(expressions);
            }
        }
        this.clear(simpleExpression);
    }

    private void handleOptionalType(Stack<TypeExpressionNode> expressions) {
        TypeExpressionNode optionalOf = expressions.pop();
        UnionTypeExpressionNode optionalTypeExpression = new UnionTypeExpressionNode();
        optionalTypeExpression.addChild(optionalOf);
        optionalTypeExpression.addChild(new NativeTypeExpressionNode(TypeId.NULL.getType()));
        expressions.push(optionalTypeExpression);
    }

    private void clear(StringBuilder simpleExpression) {
        simpleExpression.setLength(0);
    }

    private static class TypeExpressionParsingException
    extends Exception {
        private int location;

        public TypeExpressionParsingException(String message, int location) {
            super(message);
            this.location = location;
        }

        public int getLocation() {
            return this.location;
        }
    }
}

