/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jackson1;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.Names;
import org.raml.ramltopojo.extensions.UnionPluginContext;
import org.raml.ramltopojo.extensions.UnionTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class JacksonUnionExtension
extends UnionTypeHandlerPlugin.Helper {
    @Override
    public ClassName className(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, ClassName currentSuggestion, EventType eventType) {
        return currentSuggestion;
    }

    @Override
    public TypeSpec.Builder classCreated(UnionPluginContext unionPluginContext, UnionTypeDeclaration ramlType, TypeSpec.Builder incoming, EventType eventType) {
        ClassName deserializer = ClassName.get((String)"", (String)unionPluginContext.creationResult().getJavaName(EventType.INTERFACE).simpleName(), (String[])new String[]{Names.typeName(ramlType.name(), "deserializer")});
        ClassName serializer = ClassName.get((String)"", (String)unionPluginContext.creationResult().getJavaName(EventType.INTERFACE).simpleName(), (String[])new String[]{Names.typeName("serializer")});
        this.createSerializer(serializer, ramlType, incoming, eventType);
        this.createDeserializer(unionPluginContext, deserializer, ramlType, incoming, eventType);
        incoming.addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("using", "$T.class", new Object[]{deserializer}).build());
        incoming.addAnnotation(AnnotationSpec.builder(JsonSerialize.class).addMember("using", "$T.class", new Object[]{serializer}).build());
        return incoming;
    }

    private void createSerializer(ClassName serializerName, UnionTypeDeclaration union, TypeSpec.Builder typeBuilder, EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            return;
        }
        ClassName typeBuilderName = ClassName.get((String)"", (String)typeBuilder.build().name, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)serializerName).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SerializerBase.class), (TypeName[])new TypeName[]{typeBuilderName})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super($T.class);", new Object[]{typeBuilderName}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder serialize = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)typeBuilderName, (String)"object", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonGenerator.class), (String)"jsonGenerator", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(SerializerProvider.class), (String)"jsonSerializerProvider", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class);
        for (TypeDeclaration typeDeclaration : union.of()) {
            String isMethod = Names.methodName("is", typeDeclaration.name());
            String getMethod = Names.methodName("get", typeDeclaration.name());
            serialize.beginControlFlow("if ( object." + isMethod + "())", new Object[0]);
            serialize.addStatement("jsonGenerator.writeObject(object." + getMethod + "())", new Object[0]);
            serialize.addStatement("return", new Object[0]);
            serialize.endControlFlow();
        }
        serialize.addStatement("throw new $T($S + object)", new Object[]{IOException.class, "Can't figure out type of object"});
        builder.addMethod(serialize.build());
        typeBuilder.addType(builder.build());
    }

    private void createDeserializer(UnionPluginContext unionPluginContext, ClassName serializerName, UnionTypeDeclaration union, TypeSpec.Builder typeBuilder, EventType eventType) {
        if (eventType == EventType.IMPLEMENTATION) {
            return;
        }
        ClassName typeBuilderName = ClassName.get((String)"", (String)typeBuilder.build().name, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)serializerName).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdDeserializer.class), (TypeName[])new TypeName[]{typeBuilderName})).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super($T.class);", new Object[]{typeBuilderName}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder deserialize = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonParser.class), (String)"jsonParser", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(DeserializationContext.class), (String)"jsonContext", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class).returns((TypeName)typeBuilderName).addStatement("$T mapper  = new $T()", new Object[]{ObjectMapper.class, ObjectMapper.class}).addStatement("$T<String, Object> map = mapper.readValue(jsonParser, Map.class)", new Object[]{Map.class});
        for (TypeDeclaration typeDeclaration : union.of()) {
            ClassName unionPossibility = unionPluginContext.unionClass(typeDeclaration).getJavaName(EventType.IMPLEMENTATION);
            String name = Names.methodName("looksLike", typeDeclaration.name());
            deserialize.addStatement("if ( " + name + "(map) ) return new $T(mapper.convertValue(map, $T.class))", new Object[]{unionPluginContext.creationResult().getJavaName(EventType.IMPLEMENTATION), unionPossibility});
            this.buildLooksLike(builder, typeDeclaration);
        }
        deserialize.addStatement("throw new $T($S + map)", new Object[]{IOException.class, "Can't figure out type of object"});
        builder.addMethod(deserialize.build());
        typeBuilder.addType(builder.build());
    }

    private void buildLooksLike(TypeSpec.Builder builder, TypeDeclaration typeDeclaration) {
        String name = Names.methodName("looksLike", typeDeclaration.name());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)name).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)}), "map", new Modifier[0]);
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            ObjectTypeDeclaration otd = (ObjectTypeDeclaration)typeDeclaration;
            List names = Lists.transform((List)otd.properties(), (Function)new Function<TypeDeclaration, String>(){

                @Nullable
                public String apply(@Nullable TypeDeclaration input) {
                    return "\"" + input.name() + "\"";
                }
            });
            spec.addStatement("return map.keySet().containsAll($T.asList($L))", new Object[]{Arrays.class, Joiner.on((String)",").join((Iterable)names)});
        }
        spec.addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.BOOLEAN);
        builder.addMethod(spec.build());
    }
}

