/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.yagi.framework.model.ModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelUtils;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.model.NodeModelFactory;
import org.raml.yagi.framework.model.SimpleValueTransformer;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeSelector;
import org.raml.yagi.framework.util.NodeUtils;

public class ModelProxyBuilder {
    public static <T> T createModel(Class<T> apiInterface, NodeModel delegateNode, ModelBindingConfiguration bindingConfiguration) {
        return (T)Proxy.newProxyInstance(apiInterface.getClassLoader(), new Class[]{apiInterface, NodeModel.class}, (InvocationHandler)new SimpleProxy(delegateNode, bindingConfiguration));
    }

    private static class SimpleProxy
    implements InvocationHandler {
        private NodeModel delegate;
        private ModelBindingConfiguration bindingConfiguration;

        public SimpleProxy(NodeModel delegate, ModelBindingConfiguration bindingConfiguration) {
            this.bindingConfiguration = bindingConfiguration;
            if (delegate == null) {
                throw new IllegalArgumentException("delegate cannot be null");
            }
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Type genericReturnType = method.getGenericReturnType();
            Method delegateMethod = this.findMatchingMethod(method);
            try {
                if (delegateMethod == null) {
                    return this.fromNodeKey(method, genericReturnType);
                }
                return this.fromMethod(args, genericReturnType, delegateMethod);
            }
            catch (Exception e) {
                throw new RuntimeException("Internal error while trying to call " + method.toGenericString(), e);
            }
        }

        protected Object fromNodeKey(Method method, Type genericReturnType) {
            String propertyName = method.getName();
            if (this.delegate != null && method.getParameterTypes().length == 0) {
                return this.resolveValue(genericReturnType, NodeSelector.selectFrom(propertyName, this.delegate.getNode()));
            }
            throw new RuntimeException("Can not resolve method : " + method.getDeclaringClass().getName() + " from " + method.toGenericString() + " on " + this.delegate.getClass().getName());
        }

        protected Object fromMethod(Object[] args, Type genericReturnType, Method delegateMethod) throws IllegalAccessException, InvocationTargetException {
            Object invoke = delegateMethod.invoke((Object)this.delegate, args);
            return this.resolveValue(genericReturnType, invoke);
        }

        @Nullable
        private Object resolveValue(Type genericReturnType, Object invoke) {
            Class<?> returnType = ModelUtils.toClass(genericReturnType);
            if (invoke == null || ModelUtils.isPrimitiveOrWrapperOrString(returnType) || ModelUtils.isObject(returnType)) {
                return invoke;
            }
            if (List.class.isAssignableFrom(returnType)) {
                ArrayList<Object> returnList = new ArrayList<Object>();
                List result = (List)invoke;
                Type itemClass = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                if (ModelUtils.isPrimitiveOrWrapperOrString(ModelUtils.toClass(itemClass))) {
                    return result;
                }
                for (Object item : result) {
                    returnList.add(this.resolveValue(itemClass, item));
                }
                return returnList;
            }
            if (returnType.isAssignableFrom(invoke.getClass())) {
                return invoke;
            }
            NodeModelFactory nodeModelFactory = this.bindingConfiguration.bindingOf(returnType);
            Class<?> proxyInterface = nodeModelFactory.polymorphic() ? this.bindingConfiguration.reverseBindingOf((NodeModel)invoke) : returnType;
            return ModelProxyBuilder.createModel(proxyInterface, (NodeModel)invoke, this.bindingConfiguration);
        }

        protected Object resolveValue(Type returnType, Node node) {
            SimpleValueTransformer[] values = SimpleValueTransformer.values();
            Class<?> returnClass = ModelUtils.toClass(returnType);
            for (SimpleValueTransformer value : values) {
                if (!value.accepts(returnClass)) continue;
                return value.adaptTo(node, returnClass);
            }
            if (List.class.isAssignableFrom(returnClass) && returnType instanceof ParameterizedType) {
                Type itemClass = ((ParameterizedType)returnType).getActualTypeArguments()[0];
                ArrayList<Object> returnList = new ArrayList<Object>();
                if (NodeUtils.isNull(node)) {
                    return returnList;
                }
                if (node instanceof ArrayNode || node instanceof ObjectNode) {
                    List<Node> children = node.getChildren();
                    for (Node child : children) {
                        returnList.add(this.resolveValue(itemClass, child));
                    }
                } else {
                    returnList.add(this.resolveValue(itemClass, node));
                }
                return returnList;
            }
            if (NodeUtils.isNull(node)) {
                return null;
            }
            if (returnClass.equals(Object.class)) {
                if (node instanceof SimpleTypeNode) {
                    return ((SimpleTypeNode)node).getValue();
                }
                return null;
            }
            NodeModelFactory nodeModelFactory = this.bindingConfiguration.bindingOf(returnClass);
            NodeModel nodeModel = nodeModelFactory.create(node);
            Class<?> proxyInterface = nodeModelFactory.polymorphic() ? this.bindingConfiguration.reverseBindingOf(nodeModel) : returnClass;
            return ModelProxyBuilder.createModel(proxyInterface, nodeModel, this.bindingConfiguration);
        }

        @Nullable
        private Method findMatchingMethod(Method method) {
            try {
                return this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }
}

