/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api;

import java.lang.annotation.Annotation;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.HierarchyVisitor;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.TypeInfo;
import org.reflext.api.VisitorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationIntrospector<A extends Annotation> {
    private final Class<A> annotationClass;

    public AnnotationIntrospector(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        this.annotationClass = annotationClass;
    }

    public A resolve(ClassTypeInfo annotatedType) {
        Blah blah = new Blah();
        VisitorStrategy.Hierarchy<Blah> strategy = new VisitorStrategy.Hierarchy<Blah>();
        strategy.accept((TypeInfo)annotatedType, blah);
        return blah.annotation;
    }

    public A resolve(MethodInfo method) {
        return this.resolve(method.getOwner(), method.getSignature());
    }

    public A resolve(ClassTypeInfo declaringType, MethodSignature methodSignature) {
        Bluh bluh = new Bluh(methodSignature);
        VisitorStrategy.Hierarchy<Bluh> strategy = new VisitorStrategy.Hierarchy<Bluh>();
        strategy.accept((TypeInfo)declaringType, bluh);
        return bluh.annotation;
    }

    private class Bluh
    implements HierarchyVisitor {
        private final MethodSignature methodSignature;
        A annotation;

        private Bluh(MethodSignature methodSignature) {
            this.methodSignature = methodSignature;
        }

        public boolean enter(ClassTypeInfo type) {
            MethodInfo m = type.getDeclaredMethod(this.methodSignature);
            if (m != null) {
                this.annotation = m.getDeclaredAnnotation(AnnotationIntrospector.this.annotationClass);
            }
            return this.annotation == null;
        }

        public void leave(ClassTypeInfo type) {
        }
    }

    private class Blah
    implements HierarchyVisitor {
        A annotation;

        private Blah() {
        }

        public boolean enter(ClassTypeInfo type) {
            this.annotation = type.getDeclaredAnnotation(AnnotationIntrospector.this.annotationClass);
            return this.annotation == null;
        }

        public void leave(ClassTypeInfo type) {
        }
    }
}

