/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.introspection;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.introspection.MethodContainer;
import org.reflext.api.introspection.TypeScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodIntrospector {
    private final TypeScope typeScope;

    public MethodIntrospector(TypeScope typeScope) {
        this.typeScope = typeScope;
    }

    public Iterable<MethodInfo> getMethods(TypeInfo type) {
        return this.findMethods(type);
    }

    private MethodContainer findMethods(TypeInfo type) {
        if (type instanceof ClassTypeInfo) {
            return this.findMethods((ClassTypeInfo)type);
        }
        if (type instanceof ParameterizedTypeInfo) {
            return this.findMethods(((ParameterizedTypeInfo)type).getRawType());
        }
        throw new UnsupportedOperationException("Cannot get methods from type " + type);
    }

    private MethodContainer findMethods(ClassTypeInfo clazz) {
        TypeInfo superType;
        MethodContainer methods = this.typeScope == TypeScope.CLASS ? new MethodContainer() : ((superType = clazz.getSuperType()) == null || superType instanceof ClassTypeInfo && ((ClassTypeInfo)superType).getName().equals(Object.class.getName()) ? new MethodContainer() : this.findMethods(superType));
        if (this.typeScope == TypeScope.CLASS_AND_INTERFACE_HIERARCHY) {
            for (TypeInfo interfaceType : clazz.getInterfaces()) {
                methods.addAll(this.findMethods(interfaceType));
            }
        }
        for (MethodInfo declaredMethod : clazz.getDeclaredMethods()) {
            methods.add(declaredMethod);
        }
        return methods;
    }
}

