/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.api.annotation;

import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class AnnotationParameterType<T> {

  /** . */
  private final Class<T> javaType;
  
  private AnnotationParameterType(Class<T> javaType) {
    this.javaType = javaType;
  }

  /** . */
  public static final AnnotationParameterType<String> STRING = new AnnotationParameterType<String>(String.class);

  /** . */
  public static final AnnotationParameterType<Integer> INTEGER = new AnnotationParameterType<Integer>(Integer.class);

  /** . */
  public static final AnnotationParameterType<Long> LONG = new AnnotationParameterType<Long>(Long.class);

  /** . */
  public static final AnnotationParameterType<Boolean> BOOLEAN = new AnnotationParameterType<Boolean>(Boolean.class);

  /** . */
  public static final AnnotationParameterType<Float> FLOAT = new AnnotationParameterType<Float>(Float.class);

  /** . */
  public static final AnnotationParameterType<Byte> BYTE = new AnnotationParameterType<Byte>(Byte.class);

  /** . */
  public static final AnnotationParameterType<Short> SHORT = new AnnotationParameterType<Short>(Short.class);

  /** . */
  public static final AnnotationParameterType<Double> DOUBLE = new AnnotationParameterType<Double>(Double.class);

  /** . */
  public static final AnnotationParameterType<String> ENUM = new AnnotationParameterType<String>(String.class);

  /** . */
  public static final AnnotationParameterType<ClassTypeInfo> CLASS = new AnnotationParameterType<ClassTypeInfo>(ClassTypeInfo.class);

  /** . */
  public static final AnnotationParameterType<AnnotationInfo> ANNOTATION = new AnnotationParameterType<AnnotationInfo>(AnnotationInfo.class);
  
}
