/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.apt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.reflext.api.ClassKind;
import org.reflext.api.LiteralType;
import org.reflext.spi.model.GenericDeclarationKind;
import org.reflext.spi.model.TypeKind;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxLangTypeModel
implements TypeModel<Object> {
    private static final Map<String, LiteralType> nonPrimitiveLiteralMap;

    public TypeKind getKind(Object type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type instanceof TypeElement) {
            TypeElement elt = (TypeElement)type;
            String name = elt.getQualifiedName().toString();
            if (nonPrimitiveLiteralMap.containsKey(name)) {
                return TypeKind.SIMPLE;
            }
            return TypeKind.CLASS;
        }
        TypeMirror mirror = (TypeMirror)type;
        switch (mirror.getKind()) {
            case VOID: {
                return TypeKind.VOID;
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return TypeKind.SIMPLE;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)mirror;
                if (declaredType.getTypeArguments().isEmpty()) {
                    String name = ((TypeElement)declaredType.asElement()).getQualifiedName().toString();
                    if (nonPrimitiveLiteralMap.containsKey(name)) {
                        return TypeKind.SIMPLE;
                    }
                    return TypeKind.CLASS;
                }
                return TypeKind.PARAMETERIZED;
            }
            case TYPEVAR: {
                return TypeKind.VARIABLE;
            }
            case WILDCARD: {
                return TypeKind.WILDCARD;
            }
            case ARRAY: {
                return TypeKind.ARRAY;
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + type + " of kind " + (Object)((Object)mirror.getKind())));
    }

    public String getClassName(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            return typeElt.getQualifiedName().toString();
        }
        TypeMirror typeMirror = (TypeMirror)classType;
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return Boolean.TYPE.getName();
            }
            case BYTE: {
                return Byte.TYPE.getName();
            }
            case SHORT: {
                return Short.TYPE.getName();
            }
            case INT: {
                return Integer.TYPE.getName();
            }
            case LONG: {
                return Long.TYPE.getName();
            }
            case FLOAT: {
                return Float.TYPE.getName();
            }
            case DOUBLE: {
                return Double.TYPE.getName();
            }
            case VOID: {
                return Void.class.getName();
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)classType;
                return this.getClassName(declaredType.asElement());
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + typeMirror + " of kind  " + (Object)((Object)typeMirror.getKind()) + " as class type"));
    }

    public Iterable<Object> getInterfaces(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            ArrayList<Object> interfaces = new ArrayList<Object>();
            for (TypeMirror typeMirror : typeElt.getInterfaces()) {
                interfaces.add(typeMirror);
            }
            return interfaces;
        }
        DeclaredType declaredType = (DeclaredType)classType;
        return this.getInterfaces(declaredType.asElement());
    }

    public ClassKind getClassKind(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            switch (typeElt.getKind()) {
                case ENUM: {
                    return ClassKind.ENUM;
                }
                case ANNOTATION_TYPE: {
                    return ClassKind.ANNOTATION;
                }
                case INTERFACE: {
                    return ClassKind.INTERFACE;
                }
                case CLASS: {
                    return ClassKind.CLASS;
                }
            }
            throw new AssertionError((Object)("Cannot handle type " + typeElt + " of kind  " + (Object)((Object)typeElt.getKind()) + " as class type"));
        }
        TypeMirror mirror = (TypeMirror)classType;
        switch (mirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ClassKind.CLASS;
            }
            case VOID: {
                return ClassKind.CLASS;
            }
            case DECLARED: {
                DeclaredType declared = (DeclaredType)mirror;
                return this.getClassKind(declared.asElement());
            }
        }
        throw new AssertionError();
    }

    public Object getSuperClass(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            TypeMirror superType = typeElt.getSuperclass();
            if (superType instanceof NoType) {
                return null;
            }
            return superType;
        }
        DeclaredType declaredType = (DeclaredType)classType;
        return this.getSuperClass(declaredType.asElement());
    }

    public Iterable<Object> getTypeParameters(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            ArrayList<Object> typeParameters = new ArrayList<Object>();
            for (TypeParameterElement typeParameterElement : typeElt.getTypeParameters()) {
                typeParameters.add(typeParameterElement.asType());
            }
            return typeParameters;
        }
        DeclaredType declaredType = (DeclaredType)classType;
        return this.getTypeParameters(declaredType.asElement());
    }

    public String getName(Object typeVariable) {
        TypeParameterElement tpe = (TypeParameterElement)((TypeVariable)typeVariable).asElement();
        return tpe.getSimpleName().toString();
    }

    public GenericDeclarationKind getGenericDeclarationKind(Object typeVariable) {
        TypeParameterElement tpe = (TypeParameterElement)((TypeVariable)typeVariable).asElement();
        Element genericElt = tpe.getGenericElement();
        switch (genericElt.getKind()) {
            case INTERFACE: 
            case CLASS: {
                return GenericDeclarationKind.TYPE;
            }
            case METHOD: {
                return GenericDeclarationKind.METHOD;
            }
        }
        throw new AssertionError();
    }

    public LiteralType getLiteralType(Object simpleType) {
        if (simpleType instanceof TypeElement) {
            TypeElement elt = (TypeElement)simpleType;
            String name = elt.getQualifiedName().toString();
            LiteralType literalType = nonPrimitiveLiteralMap.get(name);
            if (literalType == null) {
                throw new AssertionError((Object)("Cannot handle type " + simpleType));
            }
            return literalType;
        }
        TypeMirror mirror = (TypeMirror)simpleType;
        switch (mirror.getKind()) {
            case BOOLEAN: {
                return LiteralType.BOOLEAN;
            }
            case BYTE: {
                return LiteralType.BYTE;
            }
            case SHORT: {
                return LiteralType.SHORT;
            }
            case INT: {
                return LiteralType.INT;
            }
            case LONG: {
                return LiteralType.LONG;
            }
            case FLOAT: {
                return LiteralType.FLOAT;
            }
            case DOUBLE: {
                return LiteralType.DOUBLE;
            }
            case DECLARED: {
                return this.getLiteralType(((DeclaredType)mirror).asElement());
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + simpleType + " of kind " + (Object)((Object)mirror.getKind())));
    }

    public Object getComponentType(Object arrayType) {
        return ((ArrayType)arrayType).getComponentType();
    }

    public boolean isPrimitive(Object simpleType) {
        if (simpleType instanceof TypeElement) {
            TypeElement elt = (TypeElement)simpleType;
            String name = elt.getQualifiedName().toString();
            if (nonPrimitiveLiteralMap.containsKey(name)) {
                return false;
            }
            throw new AssertionError((Object)("Cannot handle type " + simpleType));
        }
        TypeMirror mirror = (TypeMirror)simpleType;
        switch (mirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case DECLARED: {
                return this.isPrimitive(((DeclaredType)mirror).asElement());
            }
        }
        throw new AssertionError((Object)("Cannot handle type " + simpleType + " of kind " + (Object)((Object)mirror.getKind())));
    }

    public Object getGenericDeclaration(Object typeVariable) {
        return ((TypeParameterElement)((TypeVariable)typeVariable).asElement()).getGenericElement();
    }

    public Object getRawType(Object parameterizedType) {
        return ((DeclaredType)parameterizedType).asElement();
    }

    public Iterable<Object> getTypeArguments(Object parameterizedType) {
        ArrayList<Object> typeArguments = new ArrayList<Object>();
        for (TypeMirror typeMirror : ((DeclaredType)parameterizedType).getTypeArguments()) {
            typeArguments.add(typeMirror);
        }
        return typeArguments;
    }

    private Iterable<Object> resolveBounds(TypeMirror bound) {
        ArrayList<Object> bounds;
        block7: {
            block6: {
                if (bound == null) {
                    return Collections.emptyList();
                }
                bounds = new ArrayList<Object>();
                if (!(bound instanceof DeclaredType)) break block6;
                DeclaredType bilto = (DeclaredType)bound;
                TypeElement boundElt = (TypeElement)bilto.asElement();
                switch (boundElt.getNestingKind()) {
                    case ANONYMOUS: {
                        if (!(boundElt.getSuperclass() instanceof NoType)) {
                            bounds.add(boundElt.getSuperclass());
                        }
                        for (TypeMirror typeMirror : boundElt.getInterfaces()) {
                            bounds.add(typeMirror);
                        }
                        break block7;
                    }
                    default: {
                        bounds.add(bound);
                    }
                }
                break block7;
            }
            bounds.add(bound);
        }
        return bounds;
    }

    public Iterable<Object> getBounds(Object typeVariable) {
        TypeMirror upperBound = ((TypeVariable)typeVariable).getUpperBound();
        return this.resolveBounds(upperBound);
    }

    public Iterable<Object> getUpperBounds(Object wildcardType) {
        TypeMirror extendsBound = ((WildcardType)wildcardType).getExtendsBound();
        return this.resolveBounds(extendsBound);
    }

    public Iterable<Object> getLowerBounds(Object wildcardType) {
        TypeMirror superBounds = ((WildcardType)wildcardType).getSuperBound();
        return this.resolveBounds(superBounds);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Object classType, Class<A> annotationClass) {
        return ((DeclaredType)classType).asElement().getAnnotation(annotationClass);
    }

    static {
        HashMap<String, LiteralType> map = new HashMap<String, LiteralType>();
        map.put(Boolean.class.getName(), LiteralType.BOOLEAN);
        map.put(Byte.class.getName(), LiteralType.BYTE);
        map.put(Short.class.getName(), LiteralType.SHORT);
        map.put(Integer.class.getName(), LiteralType.INT);
        map.put(Long.class.getName(), LiteralType.LONG);
        map.put(Float.class.getName(), LiteralType.FLOAT);
        map.put(Double.class.getName(), LiteralType.DOUBLE);
        nonPrimitiveLiteralMap = map;
    }
}

