/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.apt;

import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.reflext.api.AccessScope;
import org.reflext.apt.JavaxLangFieldAnnotationModel;
import org.reflext.apt.JavaxLangFieldModel;
import org.reflext.apt.JavaxLangMethodAnnotationModel;
import org.reflext.apt.JavaxLangMethodModel;
import org.reflext.apt.JavaxLangTypeAnnotationModel;
import org.reflext.apt.JavaxLangTypeModel;
import org.reflext.spi.model.AnnotationModel;
import org.reflext.spi.model.FieldModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.ReflectionModel;
import org.reflext.spi.model.TypeModel;

public class JavaxLangReflectionModel
implements ReflectionModel<Object, ExecutableElement, AnnotationMirror, ExecutableElement, VariableElement> {
    private static final JavaxLangReflectionModel instance = new JavaxLangReflectionModel();
    private final JavaxLangTypeModel typeModel = new JavaxLangTypeModel();
    private final JavaxLangFieldModel fieldModel = new JavaxLangFieldModel();
    private final JavaxLangMethodModel methodModel = new JavaxLangMethodModel();
    private final JavaxLangTypeAnnotationModel typeAnnotationModel = new JavaxLangTypeAnnotationModel();
    private final JavaxLangMethodAnnotationModel methodAnnotationModel = new JavaxLangMethodAnnotationModel();
    private final JavaxLangFieldAnnotationModel fieldAnnotationModel = new JavaxLangFieldAnnotationModel();

    public static JavaxLangReflectionModel getInstance() {
        return instance;
    }

    public TypeModel<Object> getTypeModel() {
        return this.typeModel;
    }

    public FieldModel<Object, VariableElement> getFieldModel() {
        return this.fieldModel;
    }

    public MethodModel<Object, ExecutableElement> getMethodModel() {
        return this.methodModel;
    }

    public AnnotationModel<Object, Object, AnnotationMirror, ExecutableElement> getTypeAnnotationModel() {
        return this.typeAnnotationModel;
    }

    public AnnotationModel<Object, ExecutableElement, AnnotationMirror, ExecutableElement> getMethodAnnotationModel() {
        return this.methodAnnotationModel;
    }

    public AnnotationModel<Object, VariableElement, AnnotationMirror, ExecutableElement> getFieldAnnotationModel() {
        return this.fieldAnnotationModel;
    }

    static AccessScope getAccess(Element executableElement) {
        Set<Modifier> modifiers = executableElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return AccessScope.PUBLIC;
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return AccessScope.PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return AccessScope.PROTECTED;
        }
        return AccessScope.PACKAGE_PROTECTED;
    }

    static boolean isAbstract(Element executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    static boolean isStatic(Element executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    static boolean isNative(Element executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.NATIVE);
    }

    static boolean isFinal(Element executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.FINAL);
    }
}

