/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.api.HierarchyVisitor;
import org.reflext.api.TypeInfo;
import org.reflext.api.Visitor;
import org.reflext.api.VisitorStrategy;
import org.reflext.api.relationship.TypeRelationship;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
abstract class TypeInfoImpl<T, M> extends ReflectedObject<T, M> implements TypeInfo {

  protected TypeInfoImpl(TypeDomain<T, M> domain) {
    super(domain);
  }

  @Override
  public abstract int hashCode();

  @Override
  public abstract boolean equals(Object obj);

  public void accept(Visitor visitor) {
    _accept(visitor);
  }

  private <V extends Visitor>  void _accept(V visitor) {
    if (visitor instanceof HierarchyVisitor) {
      VisitorStrategy<HierarchyVisitor> strategy = new VisitorStrategy.Hierarchy<HierarchyVisitor>();
      strategy.accept(this, (HierarchyVisitor)visitor);
    } else {
      throw new UnsupportedOperationException();
    }
  }

  public boolean isSubType(TypeInfo ti) {
    return TypeRelationship.SUB_TYPE.isSatisfied(this, ti);
  }
}
