/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.api.LiteralType;
import org.reflext.api.SimpleTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
class SimpleTypeInfoImpl<T, M, A, P, F> extends ClassTypeInfoImpl<T, M, A, P, F> implements SimpleTypeInfo {

  /** . */
  private final LiteralType literalType;

  /** . */
  private final boolean primitive;

  public SimpleTypeInfoImpl(TypeResolverImpl<T, M, A, P, F> typeDomain, T simpleType) {
    super(typeDomain, simpleType);

    //
    this.literalType = domain.typeModel.getLiteralType(simpleType);
    this.primitive = domain.typeModel.isPrimitive(simpleType);
  }

  public boolean isPrimitive() {
    return primitive;
  }

  public LiteralType getLiteralType() {
    return literalType;
  }

  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj instanceof SimpleTypeInfo) {
      SimpleTypeInfo that = (SimpleTypeInfo)obj;
      return literalType == that.getLiteralType() && primitive == that.isPrimitive();
    }
    return false;
  }
}
