/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.core;

import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class AbstractArrayTypeInfo<T, M, A, P> extends AbstractTypeInfo<T, M, A, P> implements ArrayTypeInfo {

  public AbstractArrayTypeInfo(TypeResolverImpl<T, M, A, P> domain) {
    super(domain);
  }

  public String getName() {
    TypeInfo componentType = getComponentType();
    if (componentType instanceof SimpleTypeInfo) {
      switch (((SimpleTypeInfo)componentType).getLiteralType()) {
        case BOOLEAN:
          return "[B";
        case BYTE:
          return "[Z";
        case DOUBLE:
          return "[D";
        case INT:
          return "[I";
        case FLOAT:
          return "[F";
        case LONG:
          return "[J";
        case SHORT:
          return "[S";
        default:
          throw new AssertionError();
      }
    } else {
      return "[L" + componentType.getName() + ";";
    }
  }

  public boolean isReified() {
    return getComponentType().isReified();
  }

  public final int hashCode() {
    return 1 + getComponentType().hashCode();
  }

  public final boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj instanceof ArrayTypeInfo) {
      ArrayTypeInfo that = (ArrayTypeInfo)obj;
      return getComponentType().equals(that.getComponentType());
    }
    return false;
  }
}