/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.LiteralType;
import org.reflext.api.TypeInfo;
import org.reflext.api.annotation.AnnotationParameterInfo;
import org.reflext.api.annotation.AnnotationParameterType;
import org.reflext.core.AnnotatedDelegate;
import org.reflext.core.AnnotationInfoImpl;
import org.reflext.spi.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParameterInfoImpl<T, M, A, P, E, Z>
implements AnnotationParameterInfo<Z> {
    private static final EnumMap<LiteralType, AnnotationParameterType<?>> literalToAnnotationParameterType;
    private final AnnotatedDelegate<T, M, A, P, E> owner;
    private final A annotation;
    private final P parameter;
    private final String name;
    private final AnnotationParameterType<Z> type;
    private final boolean multiValued;
    private List<Z> values;

    public AnnotationParameterInfoImpl(AnnotatedDelegate<T, M, A, P, E> owner, A annotation, P parameter) {
        AnnotationParameterType type;
        boolean multiValued;
        String name = owner.annotationModel.getAnnotationParameterName(parameter);
        Object parameterType = owner.annotationModel.getAnnotationParameterType(parameter);
        TypeKind parameterTypeKind = owner.domain.typeModel.getKind(parameterType);
        if (parameterTypeKind == TypeKind.ARRAY) {
            parameterType = owner.domain.typeModel.getComponentType(parameterType);
            parameterTypeKind = owner.domain.typeModel.getKind(parameterType);
            multiValued = true;
        } else {
            multiValued = false;
        }
        block0 : switch (parameterTypeKind) {
            case SIMPLE: {
                LiteralType parameterLiteralType = owner.domain.typeModel.getLiteralType(parameterType);
                type = literalToAnnotationParameterType.get(parameterLiteralType);
                break;
            }
            case PARAMETERIZED: {
                Object rawParameterType = owner.domain.typeModel.getRawType(parameterType);
                String className = owner.domain.typeModel.getClassName(rawParameterType);
                if (!className.equals(Class.class.getName())) {
                    throw new AssertionError((Object)"Does not make any sense");
                }
                type = AnnotationParameterType.CLASS;
                break;
            }
            case CLASS: {
                switch (owner.domain.typeModel.getClassKind(parameterType)) {
                    case CLASS: {
                        String parameterClassName = owner.domain.typeModel.getClassName(parameterType);
                        if (parameterClassName.equals(String.class.getName())) {
                            type = AnnotationParameterType.STRING;
                            break block0;
                        }
                        if (parameterClassName.equals(Class.class.getName())) {
                            type = AnnotationParameterType.CLASS;
                            break block0;
                        }
                        throw new UnsupportedOperationException("Unsupported parameter class " + parameterClassName);
                    }
                    case ENUM: {
                        type = AnnotationParameterType.ENUM;
                        break block0;
                    }
                    case ANNOTATION: {
                        type = AnnotationParameterType.ANNOTATION;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unsupported parameter type kind " + parameterTypeKind + " for parameter " + parameter);
            }
        }
        this.owner = owner;
        this.annotation = annotation;
        this.parameter = parameter;
        this.name = name;
        this.type = type;
        this.values = null;
        this.multiValued = multiValued;
    }

    public String getName() {
        return this.name;
    }

    public AnnotationParameterType<Z> getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public List<Z> getValues() {
        if (this.values == null) {
            List annotationParameterValue = this.owner.annotationModel.getAnnotationParameterValue(this.annotation, this.parameter);
            if (this.type == AnnotationParameterType.CLASS) {
                ArrayList<Z> abc = new ArrayList<Z>(annotationParameterValue.size());
                Iterator i$ = annotationParameterValue.iterator();
                while (i$.hasNext()) {
                    Object anAnnotationParameterValue;
                    Object typeValue = anAnnotationParameterValue = i$.next();
                    TypeInfo typeValueTI = this.owner.domain.resolve(typeValue);
                    abc.add(typeValueTI);
                }
                this.values = abc;
            } else if (this.type == AnnotationParameterType.ANNOTATION) {
                ArrayList<Z> abc = new ArrayList<Z>(annotationParameterValue.size());
                Iterator i$ = annotationParameterValue.iterator();
                while (i$.hasNext()) {
                    Object anAnnotationParameterValue;
                    Object valueAnnotation = anAnnotationParameterValue = i$.next();
                    Object valueAnnotationType = this.owner.annotationModel.getAnnotationType(valueAnnotation);
                    ClassTypeInfo valueAnnotationTI = (ClassTypeInfo)this.owner.domain.resolve(valueAnnotationType);
                    AnnotationInfoImpl<T, M, A, P, E> valueAI = new AnnotationInfoImpl<T, M, A, P, E>(this.owner, valueAnnotationTI, valueAnnotation);
                    abc.add(valueAI);
                }
                this.values = abc;
            } else {
                this.values = annotationParameterValue;
            }
        }
        return this.values;
    }

    public Z getValue() {
        List<Z> values = this.getValues();
        return values.isEmpty() ? null : (Z)values.get(0);
    }

    static {
        EnumMap<LiteralType, AnnotationParameterType> tmp = new EnumMap<LiteralType, AnnotationParameterType>(LiteralType.class);
        tmp.put(LiteralType.BOOLEAN, AnnotationParameterType.BOOLEAN);
        tmp.put(LiteralType.INT, AnnotationParameterType.INTEGER);
        tmp.put(LiteralType.DOUBLE, AnnotationParameterType.DOUBLE);
        tmp.put(LiteralType.BYTE, AnnotationParameterType.BYTE);
        tmp.put(LiteralType.SHORT, AnnotationParameterType.SHORT);
        tmp.put(LiteralType.LONG, AnnotationParameterType.LONG);
        tmp.put(LiteralType.FLOAT, AnnotationParameterType.FLOAT);
        literalToAnnotationParameterType = tmp;
    }
}

