/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.core;

import org.reflext.api.AccessScope;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.FieldInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.spi.model.AnnotationModel;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class FieldInfoImpl<T, M, A, P, F> extends ReflectedObject<T, M, A, P, F> implements FieldInfo {

  /** . */
  private final ClassTypeInfo owner;

  /** . */
  private final F field;

  /** . */
  private TypeInfo type;

  /** . */
  private final String name;

  /** . */
  private final AccessScope access;

  /** . */
  private final boolean _final;

  /** . */
  private final boolean _static;

  /** . */
  private AnnotatedDelegate<T, M, A, P, F, F> annotatedDelegate;

  public FieldInfoImpl(ClassTypeInfo owner, TypeResolverImpl<T, M, A, P, F> domain, F field) {
    super(domain);

    //
    this.owner = owner;
    this.field = field;
    this.type = null;
    this.name = domain.fieldModel.getName(field);
    this.access = domain.fieldModel.getAccess(field);
    this._final = domain.fieldModel.isFinal(field);
    this._static = domain.fieldModel.isStatic(field);
    this.annotatedDelegate = null;
  }

  public ClassTypeInfo getOwner() {
    return owner;
  }

  public TypeInfo getType() {
    if (type == null) {
      T ft = domain.fieldModel.getType(field);
      type = domain.resolve(ft);
    }
    return type;
  }

  public <AT> AT getDeclaredAnnotation(AnnotationType<AT, ?> annotationType) {
    if (annotatedDelegate == null) {
      annotatedDelegate = new AnnotatedDelegate<T, M, A, P, F, F>(
        domain,
        domain.fieldAnnotationModel,
        field);
    }
    return annotatedDelegate.getDeclaredAnnotation(field, annotationType);
  }

  public String getName() {
    return name;
  }

  public AccessScope getAccess() {
    return access;
  }

  public boolean isStatic() {
    return _static;
  }

  public boolean isFinal() {
    return _final;
  }
}
