/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.jlr;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Iterator;
import java.util.LinkedHashMap;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
class MethodContainer implements Iterable<Method>  {

  /** . */
  private final Map<MethodSignature, Method> map = new LinkedHashMap<MethodSignature, Method>();

  public void addAll(Iterable<Method> methods) {
    for (Method method : methods) {
      add(method);
    }
  }

  public boolean add(Method method) {
    MethodSignature key = new MethodSignature(method);
    Method existing = map.get(key);
    if (existing != null) {
      if (existing.getReturnType().isAssignableFrom(method.getReturnType())) {
        if (existing.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
          map.put(key, method);
          return true;
        }
      }
    } else {
      map.put(key, method);
      return true;
    }
    return false;
  }

  public Iterator<Method> iterator() {
    return map.values().iterator();
  }
}
