/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.jlr;

import org.reflext.api.AccessScope;
import org.reflext.spi.model.FieldModel;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class JavaLangReflectFieldModel implements FieldModel<Type, Field> {

  public Iterable<Field> getDeclaredFields(Type classType) {
    Class<?> clazz = (Class<?>)classType;
    return Arrays.asList(clazz.getDeclaredFields());
  }

  public Type getType(Field field) {
    return field.getGenericType();
  }

  public String getName(Field field) {
    return field.getName();
  }

  public AccessScope getAccess(Field field) {
    return JavaLangReflectReflectionModel.getAccess(field);
  }

  public boolean isStatic(Field field) {
    return Modifier.isStatic(field.getModifiers());
  }

  public boolean isFinal(Field field) {
    return Modifier.isFinal(field.getModifiers());
  }

  public Type getOwner(Field field) {
    return field.getDeclaringClass();
  }
}
