/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.spi.model;

import org.reflext.api.LiteralType;
import org.reflext.api.ClassKind;

import java.lang.annotation.Annotation;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public interface TypeModel<T> {

  TypeKind getKind(T type);

  LiteralType getLiteralType(T simpleType);

  boolean isPrimitive(T simpleType);

  String getClassName(T classType);

  Iterable<T> getInterfaces(T classType);

  T getSuperClass(T classType);

  ClassKind getClassKind(T classType);

  Iterable<T> getTypeParameters(T classType);

  String getName(T typeVariable);

  T getComponentType(T arrayType);

  T getGenericDeclaration(T typeVariable);

  GenericDeclarationKind getGenericDeclarationKind(T typeVariable);

  T getRawType(T parameterizedType);

  Iterable<T> getTypeArguments(T parameterizedType);

  Iterable<T> getBounds(T typeVariable);

  Iterable<T> getUpperBounds(T wildcardType);

  Iterable<T> getLowerBounds(T wildcardType);

  <A extends Annotation> A getDeclaredAnnotation(T classType, Class<A> annotationClass);

}
