/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test;

import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
public class RuntimeUnitTestPlugin extends UnitTestPlugin {

  @Override
  protected void execute(ReflextUnitTest unitTest, Set<Class<?>> classes) throws Exception {

    //
    TypeResolver<java.lang.reflect.Type> resolver = TypeResolverImpl.create(new JavaLangReflectReflectionModel(), false);
    Map<String, java.lang.reflect.Type> types = new HashMap<String, java.lang.reflect.Type>();

    //
    for (Class<?> clazz : classes) {
      org.reflext.test.Type classTypeAnn = clazz.getAnnotation(org.reflext.test.Type.class);
      if (classTypeAnn != null) {
        types.put(classTypeAnn.value(), clazz);
      }
      for (java.lang.reflect.Method method : clazz.getDeclaredMethods()) {
        org.reflext.test.Type methodTypeAnn = method.getAnnotation(org.reflext.test.Type.class);
        if (methodTypeAnn != null) {
          types.put(methodTypeAnn.value(), method.getGenericReturnType());
        }
      }
    }

    //
    TypeDomain<java.lang.reflect.Type> domain = new TypeDomain<java.lang.reflect.Type>(resolver, types);

    //
    unitTest.run("org.reflext.jlr", domain);
  }
}
