/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test;

import junit.framework.Assert;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.test.TypeDomain;

public abstract class ReflextUnitTest
extends Assert {
    private String phase;
    private TypeDomain domain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(String phase, TypeDomain domain) throws Exception {
        try {
            this.phase = phase;
            this.domain = domain;
            this.execute();
        }
        finally {
            this.domain = null;
        }
    }

    protected final TypeInfo getTypeInfo(String typeId) {
        TypeInfo ti = this.domain.getTypeInfo(typeId);
        if (ti == null) {
            throw new AssertionError((Object)("Could not located type info with id " + typeId));
        }
        return ti;
    }

    protected final MethodInfo getMethodInfo(String methodId) {
        MethodInfo mi = this.domain.getMethodInfo(methodId);
        if (mi == null) {
            throw new AssertionError((Object)("Could not located method info with id " + methodId));
        }
        return mi;
    }

    protected final void compare(String left, Comparison comparison, String right) {
        ClassTypeInfo leftTI = (ClassTypeInfo)this.getTypeInfo(left);
        ClassTypeInfo rightTI = (ClassTypeInfo)this.getTypeInfo(right);
        switch (comparison) {
            case TO: {
                ReflextUnitTest.assertFalse((String)("Was not expecting to have " + leftTI + " assignable from " + rightTI), (boolean)leftTI.isAssignableFrom(rightTI));
                ReflextUnitTest.assertTrue((String)("Was expecting to have " + leftTI + " assignable to " + rightTI), (boolean)rightTI.isAssignableFrom(leftTI));
                break;
            }
            case SAME: {
                ReflextUnitTest.assertTrue((String)("Was expecting to have " + leftTI + " assignable from " + rightTI), (boolean)leftTI.isAssignableFrom(rightTI));
                ReflextUnitTest.assertTrue((String)("Was expecting to have " + leftTI + " assignable to " + rightTI), (boolean)rightTI.isAssignableFrom(leftTI));
                break;
            }
            case FROM: {
                ReflextUnitTest.assertTrue((String)("Was expecting to have " + leftTI + " assignable from " + rightTI), (boolean)leftTI.isAssignableFrom(rightTI));
                ReflextUnitTest.assertFalse((String)("Was not expecting to have " + leftTI + " assignable to " + rightTI), (boolean)rightTI.isAssignableFrom(leftTI));
                break;
            }
            case DIFFERENT: {
                ReflextUnitTest.assertFalse((String)("Was not expecting to have " + leftTI + " assignable from " + rightTI), (boolean)leftTI.isAssignableFrom(rightTI));
                ReflextUnitTest.assertFalse((String)("Was not expecting to have " + leftTI + " assignable to " + rightTI), (boolean)rightTI.isAssignableFrom(leftTI));
            }
        }
    }

    protected final String getPhase() {
        return this.phase;
    }

    protected final TypeInfo resolve(String contextId, String typeId) {
        TypeInfo typeInfo = this.getTypeInfo(typeId);
        ReflextUnitTest.assertNotNull((String)("Could not find type for id " + typeId), (Object)typeInfo);
        TypeInfo contextInfo = this.getTypeInfo(contextId);
        ReflextUnitTest.assertNotNull((String)("Could not find type for id " + contextId), (Object)contextInfo);
        ReflextUnitTest.assertTrue((String)("Type " + contextId + " is not a class type"), (boolean)(contextInfo instanceof ClassTypeInfo));
        return ((ClassTypeInfo)contextInfo).resolve(typeInfo);
    }

    protected final TypeInfo resolve(String contextId, TypeInfo typeInfo) {
        TypeInfo contextInfo = this.getTypeInfo(contextId);
        ReflextUnitTest.assertNotNull((String)("Could not find type for id " + contextId), (Object)contextInfo);
        ReflextUnitTest.assertTrue((String)("Type " + contextId + " is not a class type"), (boolean)(contextInfo instanceof ClassTypeInfo));
        return ((ClassTypeInfo)contextInfo).resolve(typeInfo);
    }

    protected abstract void execute() throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Comparison {
        FROM,
        SAME,
        TO,
        DIFFERENT;

    }
}

