/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.reflext.apt.JavaxLangMethodModel;
import org.reflext.apt.JavaxLangTypeModel;
import org.reflext.core.TypeDomain;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.TypeModel;
import org.reflext.test.ReflectUnitTest;
import org.reflext.test.Type;
import org.reflext.test.TypeDomainExt;
import org.reflext.test.UnitTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"org.reflext.test.UnitTest"})
public class AnnotationProcessorTestRunner
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("Starting tests");
        Set<? extends Element> elts = roundEnv.getElementsAnnotatedWith(UnitTest.class);
        for (Element element : elts) {
            TypeDomain domain = new TypeDomain((TypeModel)new JavaxLangTypeModel(), (MethodModel)new JavaxLangMethodModel());
            PackageElement packageElt = (PackageElement)element;
            System.out.println("Processing package " + packageElt.getQualifiedName());
            Map<String, Object> types = AnnotationProcessorTestRunner.findTypes(packageElt);
            Map<String, Object> map = AnnotationProcessorTestRunner.getAnnotationMap(packageElt, UnitTest.class);
            DeclaredType testType = (DeclaredType)map.get("value");
            TypeElement testElt = (TypeElement)testType.asElement();
            String name = testElt.getQualifiedName().toString();
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass(name);
                ReflectUnitTest test = (ReflectUnitTest)clazz.newInstance();
                TypeDomainExt td = new TypeDomainExt(domain, types);
                test.run(td);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return false;
    }

    private static Map<String, Object> findTypes(Element elt) {
        HashMap<String, Object> types = new HashMap<String, Object>();
        AnnotationProcessorTestRunner.findTypes(types, elt);
        return types;
    }

    private static void findTypes(Map<String, Object> types, Element elt) {
        Map<String, Object> map = AnnotationProcessorTestRunner.getAnnotationMap(elt, Type.class);
        if (map != null) {
            String id = (String)map.get("value");
            if (elt instanceof ExecutableElement) {
                types.put(id, ((ExecutableElement)elt).getReturnType());
            } else if (elt instanceof TypeElement) {
                types.put(id, elt);
            } else {
                throw new AssertionError();
            }
        }
        for (Element element : elt.getEnclosedElements()) {
            AnnotationProcessorTestRunner.findTypes(types, element);
        }
    }

    private static Map<String, Object> getAnnotationMap(Element elt, Class<? extends Annotation> annotationClass) {
        for (AnnotationMirror annotationMirror : elt.getAnnotationMirrors()) {
            TypeElement annotationTypeElt = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationTypeElt.getQualifiedName().toString().equals(annotationClass.getName())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                map.put(entry.getKey().getSimpleName().toString(), entry.getValue().getValue());
            }
            return map;
        }
        return null;
    }
}

