/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test;

import javax.tools.SimpleJavaFileObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
class LocalFileObject extends SimpleJavaFileObject {

  /** . */
  private ByteArrayOutputStream content;

  /** . */
  private boolean closed;

  public LocalFileObject(String className, Kind kind) {
    super(URI.create(className.replace('.', '/') + kind.extension), kind);

    //
    this.content = null;
    this.closed = false;
  }

  public byte[] getBytes() {
    if (closed) {
      return content.toByteArray().clone();
    } else {
      throw new IllegalStateException();
    }
  }

  @Override
  public OutputStream openOutputStream() throws IOException {
    if (content == null) {
      return content = new ByteArrayOutputStream() {
        @Override
        public void close() throws IOException {
          super.close();
          closed = true;
        }
      };
    } else {
      throw new IOException("Already opened");
    }
  }

  @Override
  public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
    if (content == null) {
      throw new IOException("No content");
    }
    if (!closed) {
      throw new IOException("Not closed");
    }
    return content.toString();
  }

  @Override
  public InputStream openInputStream() throws IOException {
    if (content == null) {
      throw new IOException("No content");
    }
    if (!closed) {
      throw new IOException("Not closed");
    }
    return new ByteArrayInputStream(content.toByteArray());
  }
}
