/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class LocalFileObject
extends SimpleJavaFileObject {
    private ByteArrayOutputStream content = null;
    private boolean closed = false;

    public LocalFileObject(String className, JavaFileObject.Kind kind) {
        super(URI.create(className.replace('.', '/') + kind.extension), kind);
    }

    public byte[] getBytes() {
        if (this.closed) {
            return (byte[])this.content.toByteArray().clone();
        }
        throw new IllegalStateException();
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.content == null) {
            this.content = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    LocalFileObject.this.closed = true;
                }
            };
            return this.content;
        }
        throw new IOException("Already opened");
    }

    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.content == null) {
            throw new IOException("No content");
        }
        if (!this.closed) {
            throw new IOException("Not closed");
        }
        return this.content.toString();
    }

    public InputStream openInputStream() throws IOException {
        if (this.content == null) {
            throw new IOException("No content");
        }
        if (!this.closed) {
            throw new IOException("Not closed");
        }
        return new ByteArrayInputStream(this.content.toByteArray());
    }
}

