/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.signature;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class SignatureUnitTest extends ReflectUnitTest {

  /** . */
  private Map<String, MethodInfo> aMethods;

  /** . */
  private Map<String, MethodInfo> bMethods;

  private void assertSameSignature(String methodName) {
    MethodInfo amInfo = aMethods.get(methodName);
    assertNotNull(amInfo);
    MethodSignature am = amInfo.getSignature();
    MethodInfo bmInfo = bMethods.get(methodName);
    assertNotNull(bmInfo);
    MethodSignature bm = bmInfo.getSignature();
    assertEquals(am, bm);
  }

  protected void execute() throws Exception {

    ClassTypeInfo a = (ClassTypeInfo)getInfo("A");
    Map<String, MethodInfo> aMethods = new HashMap<String, MethodInfo>();
    for (MethodInfo mi : a.getDeclaredMethods()) {
      aMethods.put(mi.getName(), mi);
    }

    ClassTypeInfo b = (ClassTypeInfo)getInfo("B");
    Map<String, MethodInfo> bMethods = new HashMap<String, MethodInfo>();
    for (MethodInfo mi : b.getDeclaredMethods()) {
      bMethods.put(mi.getName(), mi);
    }

    //
    this.aMethods = aMethods;
    this.bMethods = bMethods;

    assertSameSignature("m1");
    assertSameSignature("m2");
  }
}
