/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.declaredmethods;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.TypeInfo;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class DeclaredMethodsUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {
    testA();
    testB();
    testC();
    testD();
    testE();
    testF();
  }

  private void testA() {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("A");
    assertHasMethods(ti);
  }

  private void testB() {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("B");
    assertHasNoMethods(ti);
  }

  private void testC() {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("C");
    assertHasNoMethods(ti);
  }

  private void testD() {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("D");
    assertHasMethods(ti);
  }

  private void testE() {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("E");
    assertHasMethods(ti);
  }

  private void testF() {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("F");
    assertHasNoMethods(ti);
  }

  private void assertHasMethods(ClassTypeInfo cti) {
    List<MethodInfo> list = cti.getDeclaredMethods();
    assertEquals(2, list.size());
    MethodInfo m1 = list.get(0);
    assertEquals("m1", m1.getName());
    TypeInfo m1rt = m1.getReturnType();
    assertTrue("Was expecting return type to be void instead of " + m1rt, m1rt instanceof VoidTypeInfo);
    MethodInfo m2 = list.get(1);
    assertEquals("m2", m2.getName());
    assertTrue(m2.getReturnType() instanceof ClassTypeInfo);
    ClassTypeInfo m2rt = (ClassTypeInfo)m2.getReturnType();
    assertEquals(String.class.getName(), m2rt.getName());
  }

  private void assertHasNoMethods(ClassTypeInfo cti) {
    List<MethodInfo> list = cti.getDeclaredMethods();
    assertEquals(0, list.size());
  }
}