/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.introspector.annotation;

import org.reflext.api.annotation.AnnotationType;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.test.ReflectUnitTest;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class AnnotationIntrospectorUnitTest extends ReflectUnitTest {

  @Override
  protected void execute() throws Exception {
    testInheritance("A1", "A1");
    testInheritance("A2", "A2");
    testInheritance("B1", null);
    testInheritance("B2", null);
    testInheritance("C1", "A1");
    testInheritance("C2", "C2");
    testInheritance("C3", "C3");
    testInheritance("D1", "A2");
    testInheritance("D2", "D2");
    testInheritance("D3", "D3");
    testInheritance("E1", "A1");
    testInheritance("E2", "A1");
  }

  public void testInheritance(String typeId, String expectedMetaDataValue) {
    ClassTypeInfo ti = (ClassTypeInfo)getTypeInfo(typeId);
    AnnotationType<MetaData, ?> ak = AnnotationType.get(MetaData.class);
    AnnotationIntrospector<MetaData> introspector = new AnnotationIntrospector<MetaData>(ak);
    MetaData md = introspector.resolve(ti);
    if (expectedMetaDataValue == null) {
      assertNull(md);
    } else {
      assertNotNull(md);
      assertEquals(expectedMetaDataValue, md.value());
    }
  }
}
