/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.conformance.methodtype;

import org.reflext.api.MethodInfo;
import org.reflext.api.MethodType;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.test.ReflectUnitTest;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodTypeUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {
    MethodInfo concreteMethod = getMethodInfo("concrete");
    assertEquals(true, concreteMethod.isConcrete());
    assertEquals(false, concreteMethod.isAbstract());
    assertEquals(false, concreteMethod.isNative());
    assertEquals(MethodType.CONCRETE, concreteMethod.getType());

    //
    MethodInfo abstractMethod = getMethodInfo("abstract");
    assertEquals(false, abstractMethod.isConcrete());
    assertEquals(true, abstractMethod.isAbstract());
    assertEquals(false, abstractMethod.isNative());
    assertEquals(MethodType.ABSTRACT, abstractMethod.getType());

    //
    MethodInfo nativeMethod = getMethodInfo("native");
    assertEquals(false, nativeMethod.isConcrete());
    assertEquals(false, nativeMethod.isAbstract());
    assertEquals(true, nativeMethod.isNative());
    assertEquals(MethodType.NATIVE, nativeMethod.getType());
  }
}