/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.introspector.method;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;
import org.reflext.api.visit.HierarchyVisitorStrategy;
import org.reflext.test.ReflectUnitTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodIntrospectorUnitTest
extends ReflectUnitTest {
    protected void execute() throws Exception {
        this.testGetterWithScopeAll();
        this.testGetterWithScopeAncestors();
        this.testGetterWithScopeClass();
        this.testExactOverrideClass();
        this.testCovariantReturnTypeClass();
        this.testCovariantReturnTypeFull();
        this.testTypeVariableOverrideClass();
        this.testTypeVariableOverrideFull();
        this.testCovariantReturnTypeWithParallelHierarchy();
        this.testNPE();
    }

    private static <T> Set<T> set(Iterable<T> iterable) {
        HashSet<T> set = new HashSet<T>();
        for (T t : iterable) {
            if (set.contains(t)) {
                MethodIntrospectorUnitTest.fail((String)("Set " + set + " should not contain the element " + t));
            }
            set.add(t);
        }
        return set;
    }

    private void testGetterWithScopeAll() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("F1");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL, true);
        HashSet<MethodInfo> expectedGetters = new HashSet<MethodInfo>();
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredString"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredPrimitiveBoolean1"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredPrimitiveBoolean2"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredPrimitiveBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredPrimitiveBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredBoolean1"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredBoolean2"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#getOverridenInterface"));
        expectedGetters.add(this.getMethodInfo("F1#getOverridenParent"));
        expectedGetters.add(this.getMethodInfo("F2#getParentString"));
        expectedGetters.add(this.getMethodInfo("F3#getInterfaceString"));
        MethodIntrospectorUnitTest.assertEquals(expectedGetters, MethodIntrospectorUnitTest.set(spector.getGetters(ti)));
        HashSet<MethodInfo> expectedSetters = new HashSet<MethodInfo>();
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredString"));
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredPrimitiveBoolean"));
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredBoolean"));
        expectedSetters.add(this.getMethodInfo("F1#setOverridenInterface"));
        expectedSetters.add(this.getMethodInfo("F1#setOverridenParent"));
        expectedSetters.add(this.getMethodInfo("F2#setParentString"));
        expectedSetters.add(this.getMethodInfo("F3#setInterfaceString"));
        MethodIntrospectorUnitTest.assertEquals(expectedSetters, MethodIntrospectorUnitTest.set(spector.getSetters(ti)));
    }

    private void testGetterWithScopeAncestors() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("F1");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ANCESTORS, true);
        HashSet<MethodInfo> expectedGetters = new HashSet<MethodInfo>();
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredString"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredPrimitiveBoolean1"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredPrimitiveBoolean2"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredPrimitiveBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredPrimitiveBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredBoolean1"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredBoolean2"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#getOverridenInterface"));
        expectedGetters.add(this.getMethodInfo("F1#getOverridenParent"));
        expectedGetters.add(this.getMethodInfo("F2#getParentString"));
        MethodIntrospectorUnitTest.assertEquals(expectedGetters, MethodIntrospectorUnitTest.set(spector.getGetters(ti)));
        HashSet<MethodInfo> expectedSetters = new HashSet<MethodInfo>();
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredString"));
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredPrimitiveBoolean"));
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredBoolean"));
        expectedSetters.add(this.getMethodInfo("F1#setOverridenInterface"));
        expectedSetters.add(this.getMethodInfo("F1#setOverridenParent"));
        expectedSetters.add(this.getMethodInfo("F2#setParentString"));
        MethodIntrospectorUnitTest.assertEquals(expectedSetters, MethodIntrospectorUnitTest.set(spector.getSetters(ti)));
    }

    private void testGetterWithScopeClass() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("F1");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS, true);
        HashSet<MethodInfo> expectedGetters = new HashSet<MethodInfo>();
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredString"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredPrimitiveBoolean1"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredPrimitiveBoolean2"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredPrimitiveBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredPrimitiveBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredBoolean1"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredBoolean2"));
        expectedGetters.add(this.getMethodInfo("F1#getDeclaredBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#isDeclaredBoolean3"));
        expectedGetters.add(this.getMethodInfo("F1#getOverridenInterface"));
        expectedGetters.add(this.getMethodInfo("F1#getOverridenParent"));
        MethodIntrospectorUnitTest.assertEquals(expectedGetters, MethodIntrospectorUnitTest.set(spector.getGetters(ti)));
        HashSet<MethodInfo> expectedSetters = new HashSet<MethodInfo>();
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredString"));
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredPrimitiveBoolean"));
        expectedSetters.add(this.getMethodInfo("F1#setDeclaredBoolean"));
        expectedSetters.add(this.getMethodInfo("F1#setOverridenInterface"));
        expectedSetters.add(this.getMethodInfo("F1#setOverridenParent"));
        MethodIntrospectorUnitTest.assertEquals(expectedSetters, MethodIntrospectorUnitTest.set(spector.getSetters(ti)));
    }

    private void testCovariantReturnTypeWithParallelHierarchy() {
        TypeInfo bti = this.getTypeInfo("E2Impl");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.NOT_OBJECT, true);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("E2Impl_m1")), (Object)mis);
    }

    public void testExactOverrideClass() {
        TypeInfo bti = this.getTypeInfo("D2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("D2_m1")), (Object)mis);
    }

    public void testExactOverrideFull() {
        TypeInfo bti = this.getTypeInfo("D2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.NOT_OBJECT);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("D2_m1")), (Object)mis);
    }

    private void testCovariantReturnTypeClass() {
        TypeInfo bti = this.getTypeInfo("A2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("A2_m1")), (Object)mis);
    }

    private void testCovariantReturnTypeFull() {
        TypeInfo bti = this.getTypeInfo("A2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("A2_m1")), (Object)mis);
    }

    private void testTypeVariableOverrideClass() {
        TypeInfo bti = this.getTypeInfo("B2");
        Set mis = new MethodIntrospector(HierarchyScope.CLASS).getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("B2_m1")), (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.CLASS, true).getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("B2_m1")), (Object)mis);
        TypeInfo cti = this.getTypeInfo("C2");
        mis = new MethodIntrospector(HierarchyScope.CLASS).getMethods(cti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("C2_m1")), (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.CLASS, true).getMethods(cti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("C2_m1")), (Object)mis);
    }

    private void testTypeVariableOverrideFull() {
        TypeInfo bti = this.getTypeInfo("B2");
        Set mis = new MethodIntrospector(HierarchyScope.NOT_OBJECT).getMethods(bti);
        HashSet<MethodInfo> methods = new HashSet<MethodInfo>();
        methods.add(this.getMethodInfo("B1_m1"));
        methods.add(this.getMethodInfo("B2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.NOT_OBJECT, true).getMethods(bti);
        methods = new HashSet();
        methods.add(this.getMethodInfo("B2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
        TypeInfo cti = this.getTypeInfo("C2");
        mis = new MethodIntrospector(HierarchyScope.NOT_OBJECT).getMethods(cti);
        methods = new HashSet();
        methods.add(this.getMethodInfo("C1_m1"));
        methods.add(this.getMethodInfo("C2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.NOT_OBJECT, true).getMethods(cti);
        methods = new HashSet();
        methods.add(this.getMethodInfo("C2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
    }

    private void testNPE() {
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
        try {
            spector.getMethods(null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            spector.getGetterMap(null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            spector.getSetters(null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            spector.getGetters(null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            spector.getSetterMap(null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            new MethodIntrospector((HierarchyScope)null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            new MethodIntrospector((HierarchyVisitorStrategy)null);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            new MethodIntrospector((HierarchyVisitorStrategy)null, true);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException ignore) {
            // empty catch block
        }
        try {
            new MethodIntrospector((HierarchyScope)null, true);
            MethodIntrospectorUnitTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

