/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.conformance.reification;

import org.reflext.test.ReflectUnitTest;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class ReificationUnitTest extends ReflectUnitTest {

  /** . */
  private static final String A_NAME = "org.reflext.test.conformance.reification.A";

  @Override
  protected void execute() throws Exception {
    testIsReified();
    testName();
  }

  private void testName() {
    assertEquals(Object.class.getName(), getTypeInfo("m1").getName());
    assertEquals(Object[].class.getName(), getTypeInfo("m2").getName());
    assertEquals(A_NAME, getTypeInfo("m3").getName());
    assertEquals(A_NAME, getTypeInfo("m4").getName());
    assertEquals(A_NAME, getTypeInfo("m5").getName());
    assertEquals(A_NAME, getTypeInfo("m6").getName());
    assertEquals(int.class.getName(), getTypeInfo("m7").getName());
    assertEquals(int[].class.getName(), getTypeInfo("m8").getName());
    assertEquals(A_NAME, getTypeInfo("m9").getName());
    assertEquals("[L" + A_NAME + ";", getTypeInfo("m10").getName());
    assertEquals("[L" + A_NAME + ";", getTypeInfo("m11").getName());
    assertEquals("[L" + A_NAME + ";", getTypeInfo("m12").getName());
    assertEquals("[L" + A_NAME + ";", getTypeInfo("m13").getName());
  }

  private void testIsReified() {
    assertFalse(getTypeInfo("m1").isReified());
    assertFalse(getTypeInfo("m2").isReified());
    assertFalse(getTypeInfo("m3").isReified());
    assertTrue(getTypeInfo("m4").isReified());
    assertTrue(getTypeInfo("m5").isReified());
    assertFalse(getTypeInfo("m6").isReified());
    assertTrue(getTypeInfo("m7").isReified());
    assertTrue(getTypeInfo("m8").isReified());
    assertTrue(getTypeInfo("m9").isReified());
    assertTrue(getTypeInfo("m10").isReified());
    assertTrue(getTypeInfo("m11").isReified());
    assertTrue(getTypeInfo("m12").isReified());
    assertFalse(getTypeInfo("m13").isReified());
  }
}
