/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.resolver.typevariable;

import org.reflext.test.ResolverUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class TypeVariableUnitTest extends ResolverUnitTest {

  protected void execute() throws Exception {
    testA();
    testB();
    testC();
    testD();
    testH();
    testSpecialCase();
  }

  private void testA() {
    TypeInfo ti1 = resolve("A", "A_m1");
    assertTrue(ti1 instanceof TypeVariableInfo);
    TypeVariableInfo tvi1 = (TypeVariableInfo)ti1;
    assertEquals("X", tvi1.getVariableName());

    //
    ParameterizedTypeInfo A_m2 = (ParameterizedTypeInfo)getTypeInfo("A_m2");
    TypeVariableInfo X = (TypeVariableInfo)A_m2.getTypeArguments().get(0);
    TypeInfo ti2 = resolve("A", X);
    assertTrue(ti2 instanceof TypeVariableInfo);
    TypeVariableInfo tvi2 = (TypeVariableInfo)ti2;
    assertEquals("X", tvi2.getVariableName());
  }

  private void testB() {
    TypeInfo ti1 = resolve("B", "A_m1");
    assertTrue(ti1 instanceof ClassTypeInfo);
    ClassTypeInfo cti1 = (ClassTypeInfo)ti1;
    assertEquals(String.class.getName(), cti1.getName());

    //
    ParameterizedTypeInfo A_m2 = (ParameterizedTypeInfo)getTypeInfo("A_m2");
    TypeVariableInfo X = (TypeVariableInfo)A_m2.getTypeArguments().get(0);
    TypeInfo ti2 = resolve("B", X);
    assertTrue(ti2 instanceof ClassTypeInfo);
    ClassTypeInfo cti2 = (ClassTypeInfo)ti2;
    assertEquals(String.class.getName(), cti2.getName());
  }

  private void testC() {
    TypeInfo ti1 = resolve("C", "A_m1");
    assertTrue(ti1 instanceof TypeVariableInfo);
    TypeVariableInfo tvi1 = (TypeVariableInfo)ti1;
    assertEquals("Y", tvi1.getVariableName());

    //
    ParameterizedTypeInfo A_m2 = (ParameterizedTypeInfo)getTypeInfo("A_m2");
    TypeVariableInfo X = (TypeVariableInfo)A_m2.getTypeArguments().get(0);
    TypeInfo ti2 = resolve("C", X);
    assertTrue(ti2 instanceof TypeVariableInfo);
    TypeVariableInfo tvi2 = (TypeVariableInfo)ti2;
    assertEquals("Y", tvi2.getVariableName());
  }

  private void testD() {
    TypeInfo ti1 = resolve("D", "A_m1");
    assertTrue(ti1 instanceof ClassTypeInfo);
    ClassTypeInfo cti1 = (ClassTypeInfo)ti1;
    assertEquals(String.class.getName(), cti1.getName());

    //
    ParameterizedTypeInfo A_m2 = (ParameterizedTypeInfo)getTypeInfo("A_m2");
    TypeVariableInfo X = (TypeVariableInfo)A_m2.getTypeArguments().get(0);
    TypeInfo ti2 = resolve("D", X);
    assertTrue(ti2 instanceof ClassTypeInfo);
    ClassTypeInfo cti2 = (ClassTypeInfo)ti2;
    assertEquals(String.class.getName(), cti2.getName());
  }

  public void testH() {
    TypeInfo ti1 = resolve("H3", "H1_A");
    assertTrue(ti1 instanceof ClassTypeInfo);
    ClassTypeInfo cti1 = (ClassTypeInfo)ti1;
    assertEquals(String.class.getName(), cti1.getName());

    //
    TypeInfo ti2 = resolve("H3", "H1_B");
    assertTrue(ti2 instanceof ClassTypeInfo);
    ClassTypeInfo cti2 = (ClassTypeInfo)ti2;
    assertEquals(Integer.class.getName(), cti2.getName());
  }

  /**
   * Originating from a weird case in MOP project via Chromattic.
   */
  public void testSpecialCase() {
    TypeInfo ti1 = resolve("GImpl", "E_m1");
    assertTrue("Was not expecting to be " + ti1, ti1 instanceof ClassTypeInfo);
    ClassTypeInfo cti1 = (ClassTypeInfo)ti1;
    assertEquals("org.reflext.test.resolver.typevariable.F", cti1.getName());
  }
}
