/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.resolver.boundedtypevariable;

import java.util.List;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.test.ReflextUnitTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedTypeVariableUnitTest
extends ReflextUnitTest {
    protected void execute() throws Exception {
        this.testA();
        this.testB();
        this.testC();
        this.testD();
        this.testE();
        this.testF();
    }

    private void testA() {
        TypeInfo rt1 = this.resolve("A", "A_m1");
        this.assertTypeVariable(rt1, "X", Exception.class);
        TypeInfo rt2 = (TypeInfo)((ParameterizedTypeInfo)this.resolve("A", "A_m2")).getTypeArguments().get(0);
        this.assertTypeVariable(rt2, "X", Exception.class);
    }

    private void testB() {
        TypeInfo rt1 = this.resolve("B", "A_m1");
        this.assertClassType(rt1, ClassNotFoundException.class);
        TypeInfo rt2 = (TypeInfo)((ParameterizedTypeInfo)this.resolve("B", "A_m2")).getTypeArguments().get(0);
        this.assertClassType(rt2, ClassNotFoundException.class);
    }

    private void testC() {
        TypeInfo rt1 = this.resolve("C", "A_m1");
        this.assertTypeVariable(rt1, "Y", Exception.class);
        TypeInfo rt2 = (TypeInfo)((ParameterizedTypeInfo)this.resolve("C", "A_m2")).getTypeArguments().get(0);
        this.assertTypeVariable(rt2, "Y", Exception.class);
    }

    private void testD() {
        TypeInfo rt1 = this.resolve("D", "A_m1");
        this.assertClassType(rt1, ClassNotFoundException.class);
        TypeInfo rt2 = (TypeInfo)((ParameterizedTypeInfo)this.resolve("D", "A_m2")).getTypeArguments().get(0);
        this.assertClassType(rt2, ClassNotFoundException.class);
    }

    private void testE() {
        TypeInfo rt1 = this.resolve("E", "A_m1");
        this.assertTypeVariable(rt1, "Y", RuntimeException.class);
        TypeInfo rt2 = (TypeInfo)((ParameterizedTypeInfo)this.resolve("E", "A_m2")).getTypeArguments().get(0);
        this.assertTypeVariable(rt2, "Y", RuntimeException.class);
    }

    private void testF() {
        TypeInfo rt1 = this.resolve("F", "A_m1");
        this.assertClassType(rt1, ClassCastException.class);
        TypeInfo rt2 = (TypeInfo)((ParameterizedTypeInfo)this.resolve("F", "A_m2")).getTypeArguments().get(0);
        this.assertClassType(rt2, ClassCastException.class);
    }

    private void assertTypeVariable(TypeInfo typeInfo, String letter, Class<?> classBound) {
        BoundedTypeVariableUnitTest.assertTrue((String)("Was expecting type to be variable instead of " + typeInfo), (boolean)(typeInfo instanceof TypeVariableInfo));
        TypeVariableInfo tv1 = (TypeVariableInfo)typeInfo;
        BoundedTypeVariableUnitTest.assertEquals((String)letter, (String)tv1.getVariableName());
        List bounds = tv1.getBounds();
        BoundedTypeVariableUnitTest.assertEquals((int)1, (int)bounds.size());
        TypeInfo bound = (TypeInfo)bounds.get(0);
        BoundedTypeVariableUnitTest.assertTrue((boolean)(bound instanceof ClassTypeInfo));
        ClassTypeInfo boundCTI = (ClassTypeInfo)bound;
        BoundedTypeVariableUnitTest.assertEquals((String)classBound.getName(), (String)boundCTI.getName());
    }

    private void assertClassType(TypeInfo typeInfo, Class clazz) {
        BoundedTypeVariableUnitTest.assertTrue((String)("Was expecting type to be class instead of " + typeInfo), (boolean)(typeInfo instanceof ClassTypeInfo));
        ClassTypeInfo tv1 = (ClassTypeInfo)typeInfo;
        BoundedTypeVariableUnitTest.assertEquals((String)clazz.getName(), (String)tv1.getName());
    }
}

