/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Tag;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.odata.Query;
import org.restlet.ext.odata.internal.EntryContentHandler;
import org.restlet.ext.odata.internal.edm.AssociationEnd;
import org.restlet.ext.odata.internal.edm.ComplexProperty;
import org.restlet.ext.odata.internal.edm.EntityContainer;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.FunctionImport;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.edm.Parameter;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.edm.TypeUtils;
import org.restlet.ext.odata.internal.reflect.ReflectUtils;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.util.Series;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    public static final String WCF_DATASERVICES_METADATA_NAMESPACE = "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata";
    public static final String WCF_DATASERVICES_NAMESPACE = "http://schemas.microsoft.com/ado/2007/08/dataservices";
    public static final String WCF_DATASERVICES_SCHEME_NAMESPACE = "http://schemas.microsoft.com/ado/2007/08/dataservices/scheme";
    private Client clientConnector;
    private String clientVersion;
    private ChallengeResponse credentials;
    private Request latestRequest;
    private Response latestResponse;
    private Logger logger;
    private String maxClientVersion;
    private Metadata metadata;
    private String serverVersion;
    private Reference serviceRef;

    public Service(Reference serviceRef) {
        try {
            ClientResource cr = new ClientResource(serviceRef);
            if (cr.getNext() == null) {
                Protocol protocol;
                Protocol rProtocol = cr.getProtocol();
                Reference rReference = cr.getReference();
                Object object = rProtocol != null ? rProtocol : (protocol = rReference != null ? rReference.getSchemeProtocol() : null);
                if (protocol != null) {
                    this.clientConnector = new Client(protocol);
                    cr.setNext((Uniform)this.clientConnector);
                }
            }
            cr.setFollowingRedirects(false);
            cr.get();
            this.serviceRef = cr.getStatus().isRedirection() ? cr.getLocationRef() : cr.getReference();
        }
        catch (Throwable e) {
            this.serviceRef = serviceRef;
        }
    }

    public Service(String serviceUri) {
        this(new Reference(serviceUri));
    }

    public void addEntity(String entitySetName, Object entity) throws Exception {
        if (entity != null) {
            Entry entry = this.toEntry(entity);
            ClientResource resource = this.createResource(entitySetName);
            if (this.getMetadata() == null) {
                throw new Exception("Can't add entity to this entity set " + resource.getReference() + " due to the lack of the service's metadata.");
            }
            try {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                entry.write((OutputStream)o);
                StringRepresentation r = new StringRepresentation((CharSequence)o.toString(), MediaType.APPLICATION_ATOM);
                Representation rep = resource.post((Representation)r);
                EntryContentHandler entryContentHandler = new EntryContentHandler(entity.getClass(), (Metadata)((Object)this.getMetadata()), this.getLogger());
                Feed feed = new Feed();
                feed.getEntries().add(new Entry(rep, entryContentHandler));
            }
            catch (ResourceException re) {
                throw new ResourceException(re.getStatus(), "Can't add entity to this entity set " + resource.getReference());
            }
            finally {
                this.latestRequest = resource.getRequest();
                this.latestResponse = resource.getResponse();
            }
        }
    }

    public void addLink(Object source, String sourceProperty, Object target) throws Exception {
        if (this.getMetadata() == null || source == null) {
            return;
        }
        if (target != null) {
            this.addEntity(this.getSubpath(source, sourceProperty), target);
        }
    }

    public <T> Query<T> createQuery(String subpath, Class<T> entityClass) {
        return new Query<T>(this, subpath, entityClass);
    }

    public ClientResource createResource(Reference reference) {
        ClientResource resource = new ClientResource(reference);
        if (this.clientConnector != null) {
            resource.setNext((Uniform)this.clientConnector);
        }
        resource.setChallengeResponse(this.getCredentials());
        if (this.getClientVersion() != null || this.getMaxClientVersion() != null) {
            Form form = new Form();
            if (this.getClientVersion() != null) {
                form.add("DataServiceVersion", this.getClientVersion());
            }
            if (this.getMaxClientVersion() != null) {
                form.add("MaxDataServiceVersion", this.getMaxClientVersion());
            }
            resource.getRequestAttributes().put("org.restlet.http.headers", form);
        }
        return resource;
    }

    public ClientResource createResource(String relativePath) {
        String ref = this.getServiceRef().toString();
        ref = ref.endsWith("/") ? (relativePath.startsWith("/") ? ref + relativePath.substring(1) : ref + relativePath) : (relativePath.startsWith("/") ? ref + relativePath : ref + "/" + relativePath);
        return this.createResource(new Reference(ref));
    }

    public void deleteEntity(Object entity) throws ResourceException {
        if (this.getMetadata() == null) {
            return;
        }
        ClientResource resource = this.createResource(this.getSubpath(entity));
        try {
            resource.delete();
        }
        catch (ResourceException re) {
            throw new ResourceException(re.getStatus(), "Can't delete this entity " + resource.getReference());
        }
        finally {
            this.latestRequest = resource.getRequest();
            this.latestResponse = resource.getResponse();
        }
    }

    public void deleteEntity(String entitySubpath) throws ResourceException {
        ClientResource resource = this.createResource(entitySubpath);
        try {
            resource.delete();
        }
        catch (ResourceException re) {
            throw new ResourceException(re.getStatus(), "Can't delete this entity " + resource.getReference());
        }
        finally {
            this.latestRequest = resource.getRequest();
            this.latestResponse = resource.getResponse();
        }
    }

    public void deleteLink(Object source, String sourceProperty, Object target) throws ResourceException {
        if (this.getMetadata() == null) {
            return;
        }
        this.deleteEntity(this.getSubpath(source, sourceProperty, target));
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public ChallengeResponse getCredentials() {
        return this.credentials;
    }

    public Request getLatestRequest() {
        return this.latestRequest;
    }

    public Response getLatestResponse() {
        return this.latestResponse;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Context.getCurrentLogger();
        }
        return this.logger;
    }

    public String getMaxClientVersion() {
        return this.maxClientVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getMetadata() {
        if (this.metadata == null) {
            ClientResource resource = this.createResource("$metadata");
            try {
                this.getLogger().log(Level.INFO, "Get the metadata for " + this.getServiceRef() + " at " + resource.getReference());
                Representation rep = resource.get(MediaType.APPLICATION_XML);
                this.metadata = new Metadata(rep, resource.getReference());
            }
            catch (ResourceException e) {
                this.getLogger().log(Level.SEVERE, "Can't get the metadata for " + this.getServiceRef() + " (response's status: " + resource.getStatus() + ")");
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Can't get the metadata for " + this.getServiceRef(), e);
            }
            finally {
                this.latestRequest = resource.getRequest();
                this.latestResponse = resource.getResponse();
            }
        }
        return this.metadata;
    }

    public String getServerVersion() {
        Series headers;
        String strHeader;
        Object o;
        if (this.serverVersion == null && this.latestResponse != null && (o = this.latestResponse.getAttributes().get("org.restlet.http.headers")) != null && (strHeader = (headers = (Series)o).getFirstValue("DataServiceVersion")) != null) {
            HeaderReader reader = new HeaderReader(strHeader);
            this.serverVersion = reader.readToken();
        }
        return this.serverVersion;
    }

    public Reference getServiceRef() {
        return this.serviceRef;
    }

    private String getSimpleValue(Representation representation, String tagName) throws Exception {
        String result = null;
        if (representation == null) {
            return result;
        }
        if (MediaType.APPLICATION_ALL_XML.isCompatible((org.restlet.data.Metadata)representation.getMediaType()) || MediaType.TEXT_XML.isCompatible((org.restlet.data.Metadata)representation.getMediaType())) {
            DomRepresentation xmlRep = new DomRepresentation(representation);
            Node node = null;
            try {
                NodeList nl = xmlRep.getDocument().getElementsByTagName(tagName);
                node = nl.getLength() > 0 ? nl.item(0) : null;
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (node != null) {
                result = XmlRepresentation.getTextContent(node);
            }
        } else {
            result = representation.getText();
        }
        return result;
    }

    private String getSubpath(Object entity) {
        return ((Metadata)((Object)this.getMetadata())).getSubpath(entity);
    }

    private String getSubpath(Object entity, String propertyName) {
        return ((Metadata)((Object)this.getMetadata())).getSubpath(entity, propertyName);
    }

    private String getSubpath(Object source, String sourceProperty, Object target) {
        return ((Metadata)((Object)this.getMetadata())).getSubpath(source, sourceProperty, target);
    }

    private String getTag(Object entity) {
        String result = null;
        if (entity != null) {
            Metadata metadata = (Metadata)((Object)this.getMetadata());
            EntityType type = metadata.getEntityType(entity.getClass());
            StringBuilder sb = new StringBuilder();
            boolean found = false;
            for (Property property : type.getProperties()) {
                if (!property.isConcurrent()) continue;
                found = true;
                Object value = null;
                try {
                    value = ReflectUtils.invokeGetter(entity, property.getName());
                    if (value == null) continue;
                    sb.append(value);
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot get the value of the property " + property.getName() + " on " + entity);
                }
            }
            if (found) {
                result = Reference.encode((String)sb.toString(), (CharacterSet)CharacterSet.US_ASCII);
            }
        }
        return result;
    }

    public Representation getValue(Object entity) throws ResourceException {
        Reference ref = this.getValueRef(entity);
        if (ref != null) {
            ClientResource cr = this.createResource(ref);
            return cr.get();
        }
        return null;
    }

    public Representation getValue(Object entity, List<Preference<MediaType>> acceptedMediaTypes) throws ResourceException {
        Reference ref = this.getValueRef(entity);
        if (ref != null) {
            ClientResource cr = this.createResource(ref);
            cr.getClientInfo().setAcceptedMediaTypes(acceptedMediaTypes);
            return cr.get();
        }
        return null;
    }

    public Representation getValue(Object entity, MediaType mediaType) throws ResourceException {
        Reference ref = this.getValueRef(entity);
        if (ref != null) {
            ClientResource cr = this.createResource(ref);
            return cr.get(mediaType);
        }
        return null;
    }

    private Reference getValueEditRef(Object entity) {
        if (entity != null) {
            Metadata metadata = (Metadata)((Object)this.getMetadata());
            EntityType type = metadata.getEntityType(entity.getClass());
            if (type.isBlob() && type.getBlobValueEditRefProperty() != null) {
                try {
                    return (Reference)ReflectUtils.invokeGetter(entity, type.getBlobValueEditRefProperty().getName());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot get the value of the property " + type.getBlobValueEditRefProperty().getName() + " on " + entity);
                }
            } else {
                this.getLogger().warning("This entity is not a media resource " + entity);
            }
        }
        return null;
    }

    public Reference getValueRef(Object entity) {
        if (entity != null) {
            Metadata metadata = (Metadata)((Object)this.getMetadata());
            EntityType type = metadata.getEntityType(entity.getClass());
            if (type.isBlob() && type.getBlobValueRefProperty() != null) {
                try {
                    return (Reference)ReflectUtils.invokeGetter(entity, type.getBlobValueRefProperty().getName());
                }
                catch (Exception e) {
                    this.getLogger().warning("Cannot get the value of the property " + type.getBlobValueRefProperty().getName() + " on " + entity);
                }
            } else {
                this.getLogger().warning("This entity is not a media resource " + entity);
            }
        }
        return null;
    }

    public Representation invokeComplex(String service, Series<org.restlet.data.Parameter> parameters) throws ResourceException {
        Representation result = null;
        Metadata metadata = (Metadata)((Object)this.getMetadata());
        if (metadata != null && service != null) {
            FunctionImport function = null;
            for (EntityContainer container : metadata.getContainers()) {
                for (FunctionImport f : container.getFunctionImports()) {
                    if (!service.equals(f.getName())) continue;
                    function = f;
                    break;
                }
                if (function == null) continue;
                break;
            }
            if (function != null) {
                ClientResource resource = this.createResource(service);
                resource.setMethod(function.getMethod());
                if (parameters != null) {
                    for (Parameter parameter : function.getParameters()) {
                        resource.getReference().addQueryParameter(parameter.getName(), TypeUtils.getLiteralForm(parameters.getFirstValue(parameter.getName()), parameter.getType()));
                    }
                }
                result = resource.handle();
                this.latestRequest = resource.getRequest();
                this.latestResponse = resource.getResponse();
                if (resource.getStatus().isError()) {
                    throw new ResourceException(resource.getStatus());
                }
            }
        }
        return result;
    }

    public String invokeSimple(String service, Series<org.restlet.data.Parameter> parameters) throws ResourceException, Exception {
        return this.getSimpleValue(this.invokeComplex(service, parameters), service);
    }

    public void loadProperty(Object entity, String propertyName) {
        EntityType type;
        if (this.getMetadata() == null || entity == null) {
            return;
        }
        Metadata metadata = (Metadata)((Object)this.getMetadata());
        AssociationEnd association = metadata.getAssociation(type = metadata.getEntityType(entity.getClass()), propertyName);
        if (association != null) {
            EntityType propertyEntityType = association.getType();
            try {
                Class<?> propertyClass = ReflectUtils.getSimpleClass(entity, propertyName);
                if (propertyClass == null) {
                    propertyClass = TypeUtils.getJavaClass(propertyEntityType);
                }
                Iterator<?> iterator = this.createQuery(this.getSubpath(entity, propertyName), propertyClass).iterator();
                ReflectUtils.setProperty(entity, propertyName, association.isToMany(), iterator, propertyClass);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Can't set the property " + propertyName + " of " + entity.getClass() + " for the service" + this.getServiceRef(), e);
            }
        } else {
            ClientResource resource = this.createResource(this.getSubpath(entity, propertyName));
            try {
                Representation rep = resource.get();
                try {
                    String value = this.getSimpleValue(rep, propertyName);
                    Property property = metadata.getProperty(entity, propertyName);
                    ReflectUtils.setProperty(entity, property, value);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Can't set the property " + propertyName + " of " + entity.getClass() + " for the service" + this.getServiceRef(), e);
                }
            }
            catch (ResourceException e) {
                this.getLogger().log(Level.WARNING, "Can't get the following resource " + resource.getReference() + " for the service" + this.getServiceRef(), e);
            }
        }
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setCredentials(ChallengeResponse credentials) {
        this.credentials = credentials;
    }

    public void setLatestRequest(Request latestRequest) {
        this.latestRequest = latestRequest;
    }

    public void setLatestResponse(Response latestResponse) {
        this.latestResponse = latestResponse;
    }

    public void setLink(Object source, String sourceProperty, Object target) throws Exception {
        if (this.getMetadata() == null || source == null) {
            return;
        }
        if (target != null) {
            Metadata metadata = (Metadata)((Object)this.getMetadata());
            ClientResource resource = this.createResource(metadata.getSubpath(source) + "/$links/" + sourceProperty);
            try {
                StringBuilder sb = new StringBuilder("<uri xmlns=\"");
                sb.append(WCF_DATASERVICES_NAMESPACE);
                sb.append("\">");
                sb.append(this.getServiceRef().toString());
                sb.append(metadata.getSubpath(target));
                sb.append("</uri>");
                StringRepresentation r = new StringRepresentation((CharSequence)sb.toString(), MediaType.APPLICATION_XML);
                resource.put((Representation)r);
            }
            catch (ResourceException re) {
                throw new ResourceException(re.getStatus(), "Can't set entity to this entity set " + resource.getReference());
            }
            finally {
                this.latestRequest = resource.getRequest();
                this.latestResponse = resource.getResponse();
            }
        } else {
            ReflectUtils.invokeSetter(source, sourceProperty, null);
            this.updateEntity(source);
        }
    }

    public void setMaxClientVersion(String maxClientVersion) {
        this.maxClientVersion = maxClientVersion;
    }

    public void setValue(Object entity, Representation blob) throws ResourceException {
        Reference ref = this.getValueEditRef(entity);
        if (ref != null) {
            ClientResource cr = this.createResource(ref);
            cr.put(blob);
        }
    }

    public Entry toEntry(final Object entity) {
        Metadata metadata;
        EntityType type;
        Entry result = null;
        if (entity != null && (type = (metadata = (Metadata)((Object)this.getMetadata())).getEntityType(entity.getClass())) != null) {
            final SaxRepresentation r = new SaxRepresentation(MediaType.APPLICATION_XML){

                public void write(XmlWriter writer) throws IOException {
                    try {
                        AttributesImpl nullAttrs = new AttributesImpl();
                        nullAttrs.addAttribute(Service.WCF_DATASERVICES_METADATA_NAMESPACE, "null", null, "boolean", "true");
                        writer.forceNSDecl(Service.WCF_DATASERVICES_METADATA_NAMESPACE, "m");
                        writer.forceNSDecl(Service.WCF_DATASERVICES_NAMESPACE, "d");
                        writer.startElement(Service.WCF_DATASERVICES_METADATA_NAMESPACE, "properties");
                        this.write(writer, entity, nullAttrs);
                        writer.endElement(Service.WCF_DATASERVICES_METADATA_NAMESPACE, "properties");
                    }
                    catch (SAXException e) {
                        throw new IOException(e.getMessage());
                    }
                }

                private void write(XmlWriter writer, Object entity2, AttributesImpl nullAttrs) throws SAXException {
                    for (Field field : entity2.getClass().getDeclaredFields()) {
                        String getter = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                        Property prop = ((Metadata)((Object)Service.this.getMetadata())).getProperty(entity2, field.getName());
                        if (prop == null) continue;
                        this.writeProperty(writer, entity2, prop, getter, nullAttrs);
                    }
                }

                private void writeProperty(XmlWriter writer, Object entity2, Property prop, String getter, AttributesImpl nullAttrs) throws SAXException {
                    for (Method method : entity2.getClass().getDeclaredMethods()) {
                        if (method.getReturnType() == null || !getter.equals(method.getName()) || method.getParameterTypes().length != 0) continue;
                        Object value = null;
                        try {
                            value = method.invoke(entity2, (Object[])null);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (value != null) {
                            writer.startElement(Service.WCF_DATASERVICES_NAMESPACE, prop.getName());
                            if (prop instanceof ComplexProperty) {
                                this.write(writer, value, nullAttrs);
                            } else {
                                writer.characters(TypeUtils.toEdm(value, prop.getType()));
                            }
                            writer.endElement(Service.WCF_DATASERVICES_NAMESPACE, prop.getName());
                            break;
                        }
                        if (prop.isNullable()) {
                            writer.emptyElement(Service.WCF_DATASERVICES_NAMESPACE, prop.getName(), prop.getName(), (Attributes)nullAttrs);
                            break;
                        }
                        Service.this.getLogger().warning("The following property has a null value but is not marked as nullable: " + prop.getName());
                        writer.emptyElement(Service.WCF_DATASERVICES_NAMESPACE, prop.getName());
                        break;
                    }
                }
            };
            if (type.isBlob()) {
                result = new Entry(){

                    public void writeInlineContent(XmlWriter writer) throws SAXException {
                        try {
                            r.write(writer);
                        }
                        catch (IOException e) {
                            throw new SAXException(e);
                        }
                    }
                };
                Link editLink = new Link(this.getValueEditRef(entity), Relation.EDIT_MEDIA, null);
                result.getLinks().add(editLink);
                Content content = new Content();
                content.setExternalRef(this.getValueRef(entity));
                content.setToEncode(false);
                result.setContent(content);
            } else {
                result = new Entry();
                Content content = new Content();
                content.setInlineContent((Representation)r);
                content.setToEncode(false);
                result.setContent(content);
            }
        }
        return result;
    }

    public void updateEntity(Object entity) throws Exception {
        if (this.getMetadata() == null || entity == null) {
            return;
        }
        Entry entry = this.toEntry(entity);
        ClientResource resource = this.createResource(this.getSubpath(entity));
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            entry.write((OutputStream)o);
            StringRepresentation r = new StringRepresentation((CharSequence)o.toString(), MediaType.APPLICATION_ATOM);
            String tag = this.getTag(entity);
            if (tag != null) {
                resource.getConditions().setMatch(Arrays.asList(new Tag(tag)));
            }
            resource.put((Representation)r);
        }
        catch (ResourceException re) {
            throw new ResourceException(re.getStatus(), "Can't update this entity " + resource.getReference());
        }
        finally {
            this.latestRequest = resource.getRequest();
            this.latestResponse = resource.getResponse();
        }
    }
}

