/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf;

import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.Literal;
import org.restlet.util.Triple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link
extends Triple<Object, Reference, Object> {
    public static Reference createBlankRef(String identifier) {
        return new Reference("_:" + identifier);
    }

    public static boolean isBlankRef(Reference reference) {
        return reference != null && "_".equals(reference.getScheme());
    }

    public Link(Graph sourceGraph, Reference typeRef, Literal targetLit) {
        this((Object)sourceGraph, typeRef, (Object)targetLit);
    }

    public Link(Graph sourceGraph, Reference typeRef, Object target) {
        this((Object)sourceGraph, typeRef, target);
    }

    public Link(Graph sourceGraph, Reference typeRef, Reference targetRef) {
        this(sourceGraph, typeRef, (Object)targetRef);
    }

    public Link(Graph sourceGraph, String typeRef, Literal targetLit) {
        this(sourceGraph, new Reference(typeRef), targetLit);
    }

    public Link(Graph sourceGraph, String typeRef, Object target) {
        this(sourceGraph, new Reference(typeRef), target);
    }

    public Link(Graph sourceGraph, String typeRef, Reference targetRef) {
        this(sourceGraph, new Reference(typeRef), targetRef);
    }

    public Link(Link from) {
        this(from.getSource(), from.getTypeRef(), from.getTarget());
    }

    private Link(Object source, Reference typeRef, Object target) {
        super(source, (Object)typeRef, target);
    }

    public Link(Reference sourceRef, Reference typeRef, Literal targetLit) {
        this((Object)sourceRef, typeRef, (Object)targetLit);
    }

    public Link(Reference sourceRef, Reference typeRef, Reference targetRef) {
        this((Object)sourceRef, typeRef, (Object)targetRef);
    }

    public Link(Reference sourceRef, String typeRef, Literal targetLit) {
        this(sourceRef, new Reference(typeRef), targetLit);
    }

    public Link(Reference sourceRef, String typeRef, Reference targetRef) {
        this(sourceRef, new Reference(typeRef), targetRef);
    }

    public Object getSource() {
        return this.getFirst();
    }

    public Graph getSourceAsGraph() {
        return this.hasGraphSource() ? (Graph)this.getSource() : null;
    }

    public Link getSourceAsLink() {
        return this.hasLinkSource() ? (Link)((Object)this.getSource()) : null;
    }

    public Reference getSourceAsReference() {
        return this.hasReferenceSource() ? (Reference)this.getSource() : null;
    }

    public Object getTarget() {
        return this.getThird();
    }

    public Graph getTargetAsGraph() {
        return this.hasGraphTarget() ? (Graph)this.getTarget() : null;
    }

    public Link getTargetAsLink() {
        return this.hasLinkTarget() ? (Link)((Object)this.getTarget()) : null;
    }

    public Literal getTargetAsLiteral() {
        return this.hasLiteralTarget() ? (Literal)this.getTarget() : null;
    }

    public Reference getTargetAsReference() {
        return this.hasReferenceTarget() ? (Reference)this.getTarget() : null;
    }

    public Reference getTypeRef() {
        return (Reference)this.getSecond();
    }

    public boolean hasGraphSource() {
        return this.getSource() instanceof Graph;
    }

    public boolean hasGraphTarget() {
        return this.getTarget() instanceof Graph;
    }

    public boolean hasLinkSource() {
        return this.getSource() instanceof Link;
    }

    public boolean hasLinkTarget() {
        return this.getTarget() instanceof Link;
    }

    public boolean hasLiteralTarget() {
        return this.getTarget() instanceof Literal;
    }

    public boolean hasReferenceSource() {
        return this.getSource() instanceof Reference;
    }

    public boolean hasReferenceTarget() {
        return this.getTarget() instanceof Reference;
    }

    public void setSource(Graph sourceGraph) {
        this.setFirst(sourceGraph);
    }

    public void setSource(Link sourceLink) {
        this.setFirst((Object)sourceLink);
    }

    public void setSource(Reference sourceRef) {
        this.setFirst(sourceRef);
    }

    public void setTarget(Graph targetGraph) {
        this.setThird(targetGraph);
    }

    public void setTarget(Link targetLink) {
        this.setThird((Object)targetLink);
    }

    public void setTarget(Literal targetLit) {
        this.setThird(targetLit);
    }

    public void setTarget(Reference targetRef) {
        this.setThird(targetRef);
    }

    public void setTypeRef(Reference typeRef) {
        this.setSecond(typeRef);
    }
}

