/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.data.Parameter;
import org.restlet.ext.ssl.SslContextFactory;
import org.restlet.ext.ssl.internal.DefaultSslContext;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSslContextFactory
extends SslContextFactory {
    private volatile String certAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm());
    private volatile String[] disabledCipherSuites = null;
    private volatile String[] enabledCipherSuites = null;
    private volatile char[] keyStoreKeyPassword = System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")) != null ? System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")).toCharArray() : null;
    private volatile char[] keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword") != null ? System.getProperty("javax.net.ssl.keyStorePassword").toCharArray() : null;
    private volatile String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private volatile String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
    private volatile String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
    private volatile boolean needClientAuthentication = false;
    private volatile String secureRandomAlgorithm = null;
    private volatile String sslProtocol = "TLS";
    private volatile String trustManagerAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm());
    private volatile char[] trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword").toCharArray() : null;
    private volatile String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private volatile String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
    private volatile String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
    private volatile boolean wantClientAuthentication = false;

    protected final DefaultSslContextFactory clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLContext createSslContext() throws Exception {
        DefaultSslContext result = null;
        KeyManagerFactory kmf = null;
        if (this.keyStorePath != null || this.keyStoreProvider != null || this.keyStoreType != null) {
            KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
            FileInputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = this.keyStorePath != null && !"NONE".equals(this.keyStorePath) ? new FileInputStream(this.keyStorePath) : null;
                keyStore.load(keyStoreInputStream, this.keyStorePassword);
            }
            finally {
                if (keyStoreInputStream != null) {
                    keyStoreInputStream.close();
                }
            }
            kmf = KeyManagerFactory.getInstance(this.certAlgorithm);
            kmf.init(keyStore, this.keyStoreKeyPassword);
        }
        TrustManagerFactory tmf = null;
        if (this.trustStorePath != null || this.trustStoreProvider != null || this.trustStoreType != null) {
            KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
            FileInputStream trustStoreInputStream = null;
            try {
                trustStoreInputStream = this.trustStorePath != null && !"NONE".equals(this.trustStorePath) ? new FileInputStream(this.trustStorePath) : null;
                trustStore.load(trustStoreInputStream, this.trustStorePassword);
            }
            finally {
                if (trustStoreInputStream != null) {
                    trustStoreInputStream.close();
                }
            }
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            tmf.init(trustStore);
        }
        SSLContext sslContext = SSLContext.getInstance(this.sslProtocol);
        SecureRandom sr = null;
        if (this.secureRandomAlgorithm != null) {
            sr = SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, sr);
        result = new DefaultSslContext(this, sslContext);
        return result;
    }

    public String getCertAlgorithm() {
        return this.certAlgorithm;
    }

    public String[] getDisabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public char[] getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Override
    public void init(Series<Parameter> helperParameters) {
        this.setKeyStorePath(helperParameters.getFirstValue("keyStorePath", true, System.getProperty("javax.net.ssl.keyStore")));
        this.setKeyStorePassword(helperParameters.getFirstValue("keyStorePassword", true, System.getProperty("javax.net.ssl.keyStorePassword", "")));
        this.setKeyStoreType(helperParameters.getFirstValue("keyStoreType", true, System.getProperty("javax.net.ssl.keyStoreType")));
        this.setKeyStoreKeyPassword(helperParameters.getFirstValue("keyPassword", true, System.getProperty("javax.net.ssl.keyPassword")));
        if (this.keyStoreKeyPassword == null) {
            this.keyStoreKeyPassword = this.keyStorePassword;
        }
        this.setTrustStorePath(helperParameters.getFirstValue("trustStorePath", true, System.getProperty("javax.net.ssl.trustStore")));
        this.setTrustStorePassword(helperParameters.getFirstValue("trustStorePassword", System.getProperty("javax.net.ssl.trustStorePassword")));
        this.setTrustStoreType(helperParameters.getFirstValue("trustStoreType", true, System.getProperty("javax.net.ssl.trustStoreType")));
        this.setCertAlgorithm(helperParameters.getFirstValue("certAlgorithm", true, "SunX509"));
        this.setSslProtocol(helperParameters.getFirstValue("sslProtocol", true, "TLS"));
        this.setNeedClientAuthentication(Boolean.parseBoolean(helperParameters.getFirstValue("needClientAuthentication", true, "false")));
        this.setWantClientAuthentication(Boolean.parseBoolean(helperParameters.getFirstValue("wantClientAuthentication", true, "false")));
    }

    public boolean isNeedClientAuthentication() {
        return this.needClientAuthentication;
    }

    public boolean isWantClientAuthentication() {
        return this.wantClientAuthentication;
    }

    public void setCertAlgorithm(String keyManagerAlgorithm) {
        this.certAlgorithm = keyManagerAlgorithm;
    }

    public void setDisabledCipherSuites(String[] disabledCipherSuites) {
        this.disabledCipherSuites = disabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setKeyStoreKeyPassword(char[] keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword != null ? keyStoreKeyPassword.toCharArray() : null;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setNeedClientAuthentication(boolean needClientAuthentication) {
        this.needClientAuthentication = needClientAuthentication;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setWantClientAuthentication(boolean wantClientAuthentication) {
        this.wantClientAuthentication = wantClientAuthentication;
    }
}

