/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.ConverterUtils;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;
import org.restlet.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterService
extends Service {
    public ConverterService() {
    }

    public ConverterService(boolean enabled) {
        super(enabled);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        ArrayList result = null;
        List<Class<?>> helperObjectClasses = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            helperObjectClasses = ch.getObjectClasses(source);
            if (helperObjectClasses == null) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(helperObjectClasses);
        }
        return result;
    }

    public List<? extends Variant> getVariants(Class<?> source, Variant target) {
        return ConverterUtils.getVariants(source, target);
    }

    public Object toObject(Representation source) throws IOException {
        return this.toObject(source, null, null);
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        T result = null;
        if (source != null && source.isAvailable() && source.getSize() != 0L) {
            ConverterHelper ch = ConverterUtils.getBestHelper(source, target, resource);
            if (ch != null) {
                Context.getCurrentLogger().fine("The following converter was selected for the " + source + " representation: " + ch);
                result = ch.toObject(source, target, resource);
                if (result instanceof Representation) {
                    Representation resultRepresentation = (Representation)result;
                    resultRepresentation.setCharacterSet(source.getCharacterSet());
                    resultRepresentation.setMediaType(source.getMediaType());
                    resultRepresentation.getEncodings().addAll(source.getEncodings());
                    resultRepresentation.getLanguages().addAll(source.getLanguages());
                }
            } else {
                Context.getCurrentLogger().warning("Unable to find a converter for this representation : " + source);
            }
        }
        return result;
    }

    public Representation toRepresentation(Object source) {
        return this.toRepresentation(source, null, null);
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) {
        Representation result;
        block13: {
            result = null;
            ConverterHelper ch = ConverterUtils.getBestHelper(source, target, resource);
            if (ch != null) {
                try {
                    Context.getCurrentLogger().fine("The following converter was selected for the " + source + " object: " + ch);
                    if (target == null) {
                        List<VariantInfo> variants = ch.getVariants(source.getClass());
                        target = variants != null && !variants.isEmpty() ? (resource != null ? resource.getClientInfo().getPreferredVariant(variants, resource.getMetadataService()) : (Variant)variants.get(0)) : new Variant();
                    }
                    if ((result = ch.toRepresentation(source, target, resource)) == null) break block13;
                    if (result.getCharacterSet() == null) {
                        result.setCharacterSet(target.getCharacterSet());
                    }
                    if (result.getMediaType() == null || !result.getMediaType().isConcrete()) {
                        if (target.getMediaType() != null && target.getMediaType().isConcrete()) {
                            result.setMediaType(target.getMediaType());
                        } else if (resource != null) {
                            result.setMediaType(resource.getMetadataService().getDefaultMediaType());
                        } else {
                            result.setMediaType(MediaType.APPLICATION_OCTET_STREAM);
                        }
                    }
                    if (result.getEncodings().isEmpty()) {
                        result.getEncodings().addAll(target.getEncodings());
                    }
                    if (result.getLanguages().isEmpty()) {
                        result.getLanguages().addAll(target.getLanguages());
                    }
                }
                catch (IOException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to convert object to a representation", e);
                }
            } else {
                Context.getCurrentLogger().warning("Unable to find a converter for this object : " + source);
            }
        }
        return result;
    }
}

