/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CookieSetting;
import org.restlet.data.Parameter;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieSettingReader
extends HeaderReader<CookieSetting> {
    private static final String NAME_SET_ACCESS_RESTRICTED = "httpOnly";
    private static final String NAME_SET_COMMENT = "comment";
    private static final String NAME_SET_COMMENT_URL = "commentURL";
    private static final String NAME_SET_DISCARD = "discard";
    private static final String NAME_SET_DOMAIN = "domain";
    private static final String NAME_SET_EXPIRES = "expires";
    private static final String NAME_SET_MAX_AGE = "max-age";
    private static final String NAME_SET_PATH = "path";
    private static final String NAME_SET_PORT = "port";
    private static final String NAME_SET_SECURE = "secure";
    private static final String NAME_SET_VERSION = "version";
    private volatile Parameter cachedPair = null;
    private volatile int globalVersion = -1;

    public static CookieSetting read(String cookieSetting) throws IllegalArgumentException {
        CookieSettingReader cr = new CookieSettingReader(cookieSetting);
        try {
            return cr.readValue();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the cookie setting", e);
        }
    }

    public CookieSettingReader(String header) {
        super(header);
    }

    private Parameter readPair() throws IOException {
        Parameter result = null;
        if (this.cachedPair != null) {
            result = this.cachedPair;
            this.cachedPair = null;
        } else {
            boolean readingName = true;
            boolean readingValue = false;
            StringBuilder nameBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            int nextChar = 0;
            while (result == null && nextChar != -1) {
                nextChar = this.read();
                if (readingName) {
                    if (HeaderUtils.isSpace(nextChar) && nameBuffer.length() == 0) continue;
                    if (nextChar == -1 || nextChar == 59 || nextChar == 44) {
                        if (nameBuffer.length() > 0) {
                            result = Parameter.create(nameBuffer, null);
                            continue;
                        }
                        if (nextChar == -1) continue;
                        throw new IOException("Empty cookie name detected. Please check your cookies");
                    }
                    if (nextChar == 61) {
                        readingName = false;
                        readingValue = true;
                        continue;
                    }
                    if (HeaderUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                        nameBuffer.append((char)nextChar);
                        continue;
                    }
                    throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
                }
                if (!readingValue || HeaderUtils.isSpace(nextChar) && valueBuffer.length() == 0) continue;
                if (nextChar == -1 || nextChar == 59) {
                    result = Parameter.create(nameBuffer, valueBuffer);
                    continue;
                }
                if (nextChar == 34 && valueBuffer.length() == 0) {
                    this.unread();
                    valueBuffer.append(this.readQuotedString());
                    continue;
                }
                if (HeaderUtils.isTokenChar(nextChar) || this.globalVersion < 1) {
                    valueBuffer.append((char)nextChar);
                    continue;
                }
                throw new IOException("Separator and control characters are not allowed within a token. Please check your cookie header");
            }
        }
        return result;
    }

    @Override
    public CookieSetting readValue() throws IOException {
        CookieSetting result = null;
        Parameter pair = this.readPair();
        while (pair != null && pair.getName().charAt(0) == '$') {
            pair = this.readPair();
        }
        if (pair != null) {
            result = new CookieSetting(pair.getName(), pair.getValue());
            pair = this.readPair();
        }
        while (pair != null) {
            if (pair.getName().equalsIgnoreCase(NAME_SET_PATH)) {
                result.setPath(pair.getValue());
            } else if (pair.getName().equalsIgnoreCase(NAME_SET_DOMAIN)) {
                result.setDomain(pair.getValue());
            } else if (pair.getName().equalsIgnoreCase(NAME_SET_COMMENT)) {
                result.setComment(pair.getValue());
            } else if (!pair.getName().equalsIgnoreCase(NAME_SET_COMMENT_URL)) {
                if (pair.getName().equalsIgnoreCase(NAME_SET_DISCARD)) {
                    result.setMaxAge(-1);
                } else if (pair.getName().equalsIgnoreCase(NAME_SET_EXPIRES)) {
                    Date current = new Date(System.currentTimeMillis());
                    Date expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_RFC_1036);
                    if (expires == null) {
                        expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_RFC_1123);
                    }
                    if (expires == null) {
                        expires = DateUtils.parse(pair.getValue(), DateUtils.FORMAT_ASC_TIME);
                    }
                    if (expires != null) {
                        if (DateUtils.after(current, expires)) {
                            result.setMaxAge((int)((expires.getTime() - current.getTime()) / 1000L));
                        } else {
                            result.setMaxAge(0);
                        }
                    } else {
                        Context.getCurrentLogger().log(Level.WARNING, "Ignoring cookie setting expiration date. Unable to parse the date: " + pair.getValue());
                    }
                } else if (pair.getName().equalsIgnoreCase(NAME_SET_MAX_AGE)) {
                    result.setMaxAge(Integer.valueOf(pair.getValue()));
                } else if (!pair.getName().equalsIgnoreCase(NAME_SET_PORT)) {
                    if (pair.getName().equalsIgnoreCase(NAME_SET_SECURE)) {
                        if (pair.getValue() == null || pair.getValue().length() == 0) {
                            result.setSecure(true);
                        }
                    } else if (pair.getName().equalsIgnoreCase(NAME_SET_ACCESS_RESTRICTED)) {
                        if (pair.getValue() == null || pair.getValue().length() == 0) {
                            result.setAccessRestricted(true);
                        }
                    } else if (pair.getName().equalsIgnoreCase(NAME_SET_VERSION)) {
                        result.setVersion(Integer.valueOf(pair.getValue()));
                    }
                }
            }
            pair = this.readPair();
        }
        return result;
    }
}

