/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOutboundWay
extends OutboundWay {
    private static String getRequestUri(Reference resourceRef, boolean isProxied) {
        Reference requestRef;
        String result = null;
        Reference reference = requestRef = resourceRef.isAbsolute() ? resourceRef : resourceRef.getTargetRef();
        if (isProxied) {
            result = requestRef.getIdentifier();
        } else {
            result = requestRef.hasQuery() ? requestRef.getPath() + "?" + requestRef.getQuery() : requestRef.getPath();
            if (result == null || result.equals("")) {
                result = "/";
            }
        }
        return result;
    }

    public ClientOutboundWay(Connection<?> connection) {
        super(connection);
    }

    @Override
    protected void addHeaders(Series<Parameter> headers) {
        Request request = this.getMessage().getRequest();
        this.addGeneralHeaders(headers);
        this.addRequestHeaders(headers);
        this.addEntityHeaders(request.getEntity(), headers);
    }

    protected void addRequestHeaders(Series<Parameter> headers) {
        HeaderUtils.addRequestHeaders(this.getMessage().getRequest(), headers);
    }

    @Override
    protected Message getActualMessage() {
        return this.getMessage().getRequest();
    }

    @Override
    public void onCompleted(boolean endReached) {
        Response message = this.getMessage();
        if (message != null) {
            Request request = message.getRequest();
            if (request.getOnSent() != null) {
                request.getOnSent().handle(request, message);
            }
            this.getMessages().remove(message);
            if (request.isExpectingResponse()) {
                this.getConnection().getInboundWay().getMessages().add(message);
            }
        }
        super.onCompleted(endReached);
    }

    @Override
    protected void writeStartLine() throws IOException {
        Request request = this.getMessage().getRequest();
        this.getLineBuilder().append(request.getMethod().getName());
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ClientOutboundWay.getRequestUri(request.getResourceRef(), this.getHelper().isProxying()));
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ClientOutboundWay.getVersion(request));
        this.getLineBuilder().append("\r\n");
    }
}

