/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.routing.Variable;
import org.restlet.util.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    public static final int MODE_EQUALS = 2;
    public static final int MODE_STARTS_WITH = 1;
    private volatile Variable defaultVariable;
    private volatile boolean encodingVariables;
    private volatile Logger logger;
    private volatile int matchingMode;
    private volatile String pattern;
    private volatile Pattern regexPattern;
    private volatile List<String> regexVariables;
    private final Map<String, Variable> variables;

    private static void appendClass(StringBuilder pattern, String content, boolean required) {
        pattern.append("(");
        if (content.equals(".")) {
            pattern.append(content);
        } else {
            pattern.append("[").append(content).append(']');
        }
        if (required) {
            pattern.append("+");
        } else {
            pattern.append("*");
        }
        pattern.append(")");
    }

    private static void appendGroup(StringBuilder pattern, String content, boolean required) {
        pattern.append("((?:").append(content).append(')');
        if (required) {
            pattern.append("+");
        } else {
            pattern.append("*");
        }
        pattern.append(")");
    }

    private static String getVariableRegex(Variable variable) {
        String result = null;
        if (variable.isFixed()) {
            result = "(" + Pattern.quote(variable.getDefaultValue()) + ")";
        } else {
            String ALL = ".";
            String ALPHA = "a-zA-Z";
            String DIGIT = "\\d";
            String ALPHA_DIGIT = "a-zA-Z\\d";
            String HEXA = "\\dABCDEFabcdef";
            String URI_UNRESERVED = "a-zA-Z\\d\\-\\.\\_\\~";
            String URI_GEN_DELIMS = "\\:\\/\\?\\#\\[\\]\\@";
            String URI_SUB_DELIMS = "\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=";
            String URI_RESERVED = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=";
            String WORD = "\\w";
            String CRLF = "\\r\\n";
            String CTL = "\\p{Cntrl}";
            String LWS = "\\r\\n\\ \\t";
            String SEPARATOR = "\\(\\)\\<\\>\\@\\,\\;\\:\\[\\]\"\\/\\\\?\\=\\{\\}\\ \\t";
            String TOKEN = "[^\\(\\)\\<\\>\\@\\,\\;\\:\\[\\]\"\\/\\\\?\\=\\{\\}\\ \\t]";
            String COMMENT = "[^\\p{Cntrl}][^\\(\\)]\\r\\n\\ \\t";
            String COMMENT_ATTRIBUTE = "[^\\;\\(\\)]";
            String PCT_ENCODED = "\\%[\\dABCDEFabcdef][\\dABCDEFabcdef]";
            String PCHAR = "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])";
            String QUERY = "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/|\\?";
            String FRAGMENT = "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/|\\?";
            String URI_PATH = "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/";
            String URI_ALL = "[\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=a-zA-Z\\d\\-\\.\\_\\~]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])";
            String QUERY_PARAM_DELIMS = "\\!\\$\\'\\(\\)\\*\\+\\,\\;";
            String QUERY_PARAM_CHAR = "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])";
            String QUERY_PARAM = "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/|\\?";
            StringBuilder coreRegex = new StringBuilder();
            switch (variable.getType()) {
                case 1: {
                    Template.appendClass(coreRegex, ".", variable.isRequired());
                    break;
                }
                case 2: {
                    Template.appendClass(coreRegex, "a-zA-Z", variable.isRequired());
                    break;
                }
                case 6: {
                    Template.appendClass(coreRegex, "\\d", variable.isRequired());
                    break;
                }
                case 3: {
                    Template.appendClass(coreRegex, "a-zA-Z\\d", variable.isRequired());
                    break;
                }
                case 8: {
                    Template.appendGroup(coreRegex, "[\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=a-zA-Z\\d\\-\\.\\_\\~]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])", variable.isRequired());
                    break;
                }
                case 15: {
                    Template.appendClass(coreRegex, "a-zA-Z\\d\\-\\.\\_\\~", variable.isRequired());
                    break;
                }
                case 16: {
                    Template.appendClass(coreRegex, "\\w", variable.isRequired());
                    break;
                }
                case 9: {
                    Template.appendGroup(coreRegex, "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/|\\?", variable.isRequired());
                    break;
                }
                case 10: {
                    Template.appendGroup(coreRegex, "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/", variable.isRequired());
                    break;
                }
                case 11: {
                    Template.appendGroup(coreRegex, "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/|\\?", variable.isRequired());
                    break;
                }
                case 12: {
                    Template.appendGroup(coreRegex, "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])|\\/|\\?", variable.isRequired());
                    break;
                }
                case 14: {
                    Template.appendGroup(coreRegex, "[a-zA-Z\\d\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[\\dABCDEFabcdef][\\dABCDEFabcdef])", variable.isRequired());
                    break;
                }
                case 7: {
                    Template.appendClass(coreRegex, "[^\\(\\)\\<\\>\\@\\,\\;\\:\\[\\]\"\\/\\\\?\\=\\{\\}\\ \\t]", variable.isRequired());
                    break;
                }
                case 4: {
                    Template.appendClass(coreRegex, "[^\\p{Cntrl}][^\\(\\)]\\r\\n\\ \\t", variable.isRequired());
                    break;
                }
                case 5: {
                    Template.appendClass(coreRegex, "[^\\;\\(\\)]", variable.isRequired());
                }
            }
            result = coreRegex.toString();
        }
        return result;
    }

    public Template(String pattern) {
        this(pattern, 2, 1, "", true, false);
    }

    public Template(String pattern, int matchingMode) {
        this(pattern, matchingMode, 1, "", true, false);
    }

    public Template(String pattern, int matchingMode, int defaultType, String defaultDefaultValue, boolean defaultRequired, boolean defaultFixed) {
        this(pattern, matchingMode, defaultType, defaultDefaultValue, defaultRequired, defaultFixed, false);
    }

    public Template(String pattern, int matchingMode, int defaultType, String defaultDefaultValue, boolean defaultRequired, boolean defaultFixed, boolean encodingVariables) {
        this.logger = this.logger == null ? Context.getCurrentLogger() : this.logger;
        this.pattern = pattern;
        this.defaultVariable = new Variable(defaultType, defaultDefaultValue, defaultRequired, defaultFixed);
        this.matchingMode = matchingMode;
        this.variables = new ConcurrentHashMap<String, Variable>();
        this.regexPattern = null;
        this.encodingVariables = encodingVariables;
    }

    public String format(Map<String, ?> values) {
        return this.format(Resolver.createResolver(values));
    }

    public String format(Request request, Response response) {
        return this.format(Resolver.createResolver(request, response));
    }

    public String format(Resolver<?> resolver) {
        StringBuilder result = new StringBuilder();
        StringBuilder varBuffer = null;
        boolean inVariable = false;
        int patternLength = this.getPattern().length();
        for (int i = 0; i < patternLength; ++i) {
            char next = this.getPattern().charAt(i);
            if (inVariable) {
                if (Reference.isUnreserved(next)) {
                    varBuffer.append(next);
                    continue;
                }
                if (next == '}') {
                    if (varBuffer.length() == 0) {
                        this.getLogger().warning("Empty pattern variables are not allowed : " + this.regexPattern);
                    } else {
                        String varValueString;
                        String varName = varBuffer.toString();
                        Object varValue = resolver.resolve(varName);
                        Variable var = this.getVariables().get(varName);
                        if (varValue == null) {
                            if (var == null) {
                                var = this.getDefaultVariable();
                            }
                            if (var != null) {
                                varValue = var.getDefaultValue();
                            }
                        }
                        String string = varValueString = varValue == null ? null : varValue.toString();
                        if (this.encodingVariables) {
                            if (var != null) {
                                result.append(var.encode(varValueString));
                            } else {
                                result.append(Reference.encode(varValueString));
                            }
                        } else if (var != null && var.isEncodingOnFormat()) {
                            result.append(Reference.encode(varValueString));
                        } else {
                            result.append(varValueString);
                        }
                        varBuffer = new StringBuilder();
                    }
                    inVariable = false;
                    continue;
                }
                this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                continue;
            }
            if (next == '{') {
                inVariable = true;
                varBuffer = new StringBuilder();
                continue;
            }
            if (next == '}') {
                this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                continue;
            }
            result.append(next);
        }
        return result.toString();
    }

    public Variable getDefaultVariable() {
        return this.defaultVariable;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMatchingMode() {
        return this.matchingMode;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getRegexPattern() {
        if (this.regexPattern == null) {
            Template template = this;
            synchronized (template) {
                if (this.regexPattern == null) {
                    this.getRegexVariables().clear();
                    StringBuilder patternBuffer = new StringBuilder();
                    StringBuilder varBuffer = null;
                    boolean inVariable = false;
                    for (int i = 0; i < this.getPattern().length(); ++i) {
                        char next = this.getPattern().charAt(i);
                        if (inVariable) {
                            if (Reference.isUnreserved(next)) {
                                varBuffer.append(next);
                                continue;
                            }
                            if (next == '}') {
                                if (varBuffer.length() == 0) {
                                    this.getLogger().warning("Empty pattern variables are not allowed : " + this.regexPattern);
                                } else {
                                    String varName = varBuffer.toString();
                                    int varIndex = this.getRegexVariables().indexOf(varName);
                                    if (varIndex != -1) {
                                        patternBuffer.append("\\" + (varIndex + 1));
                                    } else {
                                        this.getRegexVariables().add(varName);
                                        Variable var = this.getVariables().get(varName);
                                        if (var == null) {
                                            var = this.getDefaultVariable();
                                        }
                                        patternBuffer.append(Template.getVariableRegex(var));
                                    }
                                    varBuffer = new StringBuilder();
                                }
                                inVariable = false;
                                continue;
                            }
                            this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                            continue;
                        }
                        if (next == '{') {
                            inVariable = true;
                            varBuffer = new StringBuilder();
                            continue;
                        }
                        if (next == '}') {
                            this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                            continue;
                        }
                        patternBuffer.append(this.quote(next));
                    }
                    this.regexPattern = Pattern.compile(patternBuffer.toString());
                }
            }
        }
        return this.regexPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRegexVariables() {
        List<String> rv = this.regexVariables;
        if (rv == null) {
            Template template = this;
            synchronized (template) {
                rv = this.regexVariables;
                if (rv == null) {
                    this.regexVariables = rv = new CopyOnWriteArrayList<String>();
                }
            }
        }
        return rv;
    }

    public List<String> getVariableNames() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder varBuffer = null;
        boolean inVariable = false;
        String pattern = this.getPattern();
        for (int i = 0; i < pattern.length(); ++i) {
            char next = pattern.charAt(i);
            if (inVariable) {
                if (Reference.isUnreserved(next)) {
                    varBuffer.append(next);
                    continue;
                }
                if (next == '}') {
                    if (varBuffer.length() == 0) {
                        this.getLogger().warning("Empty pattern variables are not allowed : " + this.pattern);
                    } else {
                        result.add(varBuffer.toString());
                        varBuffer = new StringBuilder();
                    }
                    inVariable = false;
                    continue;
                }
                this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.pattern);
                continue;
            }
            if (next == '{') {
                inVariable = true;
                varBuffer = new StringBuilder();
                continue;
            }
            if (next != '}') continue;
            this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.pattern);
        }
        return result;
    }

    public synchronized Map<String, Variable> getVariables() {
        return this.variables;
    }

    public boolean isEncodingVariables() {
        return this.encodingVariables;
    }

    public int match(String formattedString) {
        int result = -1;
        try {
            if (formattedString != null) {
                Matcher matcher = this.getRegexPattern().matcher(formattedString);
                if (this.getMatchingMode() == 2 && matcher.matches()) {
                    result = matcher.end();
                } else if (this.getMatchingMode() == 1 && matcher.lookingAt()) {
                    result = matcher.end();
                }
            }
        }
        catch (StackOverflowError soe) {
            this.getLogger().warning("StackOverflowError exception encountered while matching this string : " + formattedString);
        }
        return result;
    }

    public int parse(String formattedString, Map<String, Object> variables) {
        int result = -1;
        if (formattedString != null) {
            try {
                boolean matched;
                Matcher matcher = this.getRegexPattern().matcher(formattedString);
                boolean bl = matched = this.getMatchingMode() == 2 && matcher.matches() || this.getMatchingMode() == 1 && matcher.lookingAt();
                if (matched) {
                    result = matcher.end();
                    String attributeName = null;
                    String attributeValue = null;
                    for (int i = 0; i < this.getRegexVariables().size(); ++i) {
                        attributeName = this.getRegexVariables().get(i);
                        attributeValue = matcher.group(i + 1);
                        Variable var = this.getVariables().get(attributeName);
                        if (var != null && var.isDecodingOnParse()) {
                            variables.put(attributeName, Reference.decode(attributeValue));
                            continue;
                        }
                        variables.put(attributeName, attributeValue);
                    }
                }
            }
            catch (StackOverflowError soe) {
                this.getLogger().warning("StackOverflowError exception encountered while matching this string : " + formattedString);
            }
        }
        return result;
    }

    public int parse(String formattedString, Request request) {
        return this.parse(formattedString, request.getAttributes());
    }

    private String quote(char character) {
        switch (character) {
            case '[': {
                return "\\[";
            }
            case ']': {
                return "\\]";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                return "\\\\";
            }
            case '$': {
                return "\\$";
            }
            case '^': {
                return "\\^";
            }
            case '?': {
                return "\\?";
            }
            case '*': {
                return "\\*";
            }
            case '|': {
                return "\\|";
            }
            case '(': {
                return "\\(";
            }
            case ')': {
                return "\\)";
            }
            case ':': {
                return "\\:";
            }
            case '-': {
                return "\\-";
            }
            case '!': {
                return "\\!";
            }
            case '<': {
                return "\\<";
            }
            case '>': {
                return "\\>";
            }
        }
        return Character.toString(character);
    }

    public void setDefaultVariable(Variable defaultVariable) {
        this.defaultVariable = defaultVariable;
    }

    public void setEncodingVariables(boolean encodingVariables) {
        this.encodingVariables = encodingVariables;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setMatchingMode(int matchingMode) {
        this.matchingMode = matchingMode;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.regexPattern = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariables(Map<String, Variable> variables) {
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            if (variables != this.variables) {
                this.variables.clear();
                if (variables != null) {
                    this.variables.putAll(variables);
                }
            }
        }
    }
}

