/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.gae;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.security.Authenticator;
import org.restlet.security.Enroler;

public class GaeAuthenticator
extends Authenticator {
    private UserService userService = UserServiceFactory.getUserService();

    public GaeAuthenticator(Context context) {
        super(context);
    }

    public GaeAuthenticator(Context context, boolean optional) {
        super(context, optional);
    }

    public GaeAuthenticator(Context context, boolean optional, Enroler enroler) {
        super(context, optional, enroler);
    }

    protected boolean authenticate(Request request, Response response) {
        ClientInfo info = request.getClientInfo();
        if (info.isAuthenticated()) {
            return true;
        }
        if (this.userService.isUserLoggedIn()) {
            User gaeUser = this.userService.getCurrentUser();
            org.restlet.security.User restletUser = new org.restlet.security.User(gaeUser.getUserId());
            restletUser.setEmail(gaeUser.getEmail());
            restletUser.setFirstName(gaeUser.getNickname());
            info.setUser(restletUser);
            info.setAuthenticated(true);
            return true;
        }
        String loginUrl = this.userService.createLoginURL(request.getOriginalRef().toString());
        response.redirectTemporary(loginUrl);
        return false;
    }
}

