/**
 * Copyright 2005-2010 Noelios Technologies.
 * 
 * The contents of this file are subject to the terms of one of the following
 * open source licenses: LGPL 3.0 or LGPL 2.1 or CDDL 1.0 or EPL 1.0 (the
 * "Licenses"). You can select the license that you prefer but you may not use
 * this file except in compliance with one of these Licenses.
 * 
 * You can obtain a copy of the LGPL 3.0 license at
 * http://www.opensource.org/licenses/lgpl-3.0.html
 * 
 * You can obtain a copy of the LGPL 2.1 license at
 * http://www.opensource.org/licenses/lgpl-2.1.php
 * 
 * You can obtain a copy of the CDDL 1.0 license at
 * http://www.opensource.org/licenses/cddl1.php
 * 
 * You can obtain a copy of the EPL 1.0 license at
 * http://www.opensource.org/licenses/eclipse-1.0.php
 * 
 * See the Licenses for the specific language governing permissions and
 * limitations under the Licenses.
 * 
 * Alternatively, you can obtain a royalty free commercial license with less
 * limitations, transferable or non-transferable, directly at
 * http://www.noelios.com/products/restlet-engine
 * 
 * Restlet is a registered trademark of Noelios Technologies.
 */

/**
 * <p>
 * Implementation of JAX-RS 1.0 (JSR-311). This is the API developed by the
 * JSR-311 expert group. The main class is <a
 * href="JaxRsApplication.html">JaxRsApplication</a>.
 * </p>
 * <p>
 * <i>This extension doesn't pretend to be fully compliant with the
 * specification but it is close to completion. We are looking forward to
 * getting access to the TCK in order to validate our compatibility.</i>
 * </p>
 * 
 * @since Restlet 1.1
 * @see <a
 *      href="http://jcp.org/aboutJava/communityprocess/final/jsr311/index.html"
 *      >Specification: PDF (normative)</a>
 * @see <a
 *      href="https://jsr311.dev.java.net/nonav/releases/1.0/spec/index.html">
 *      HTML (non normative)</a>
 * @see <a href="https://jsr311.dev.java.net/">JSR-311 Web site</a>
 * @author Stephan Koops
 */
package org.restlet.ext.jaxrs;