/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs;

import java.util.Collection;
import java.util.Set;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.jaxrs.JaxRsRestlet;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.security.Authenticator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRsApplication
extends Application {
    private volatile Authenticator authenticator;
    private volatile JaxRsRestlet jaxRsRestlet;

    public JaxRsApplication() {
        this((Context)null);
    }

    public JaxRsApplication(Context context) {
        super(context);
        this.jaxRsRestlet = new JaxRsRestlet(context, this.getMetadataService());
    }

    private JaxRsApplication(Context context, javax.ws.rs.core.Application appConfig) throws IllegalArgumentException {
        this(context);
        this.add(appConfig);
    }

    public JaxRsApplication(javax.ws.rs.core.Application appConfig) throws IllegalArgumentException {
        this(Context.getCurrent(), appConfig);
    }

    public boolean add(javax.ws.rs.core.Application appConfig) throws IllegalArgumentException {
        if (appConfig == null) {
            throw new IllegalArgumentException("The ApplicationConfig must not be null");
        }
        JaxRsRestlet jaxRsRestlet = this.jaxRsRestlet;
        boolean everythingFine = true;
        if (jaxRsRestlet == null) {
            everythingFine = false;
            this.getLogger().warning("No JAX-RS to Restlet adapter available to handle to calls.");
        } else {
            Set classes = appConfig.getClasses();
            Set singletons = appConfig.getSingletons();
            if (singletons != null) {
                for (Object singleton : singletons) {
                    if (singleton == null || classes.contains(singleton.getClass())) continue;
                    everythingFine &= jaxRsRestlet.addSingleton(singleton);
                }
            }
            if (classes != null) {
                for (Class clazz : classes) {
                    everythingFine &= jaxRsRestlet.addClass(clazz);
                }
            }
        }
        return everythingFine;
    }

    public Restlet createInboundRoot() {
        JaxRsRestlet restlet = this.jaxRsRestlet;
        if (this.authenticator != null) {
            this.authenticator.setNext((Restlet)restlet);
            restlet = this.authenticator;
        }
        return restlet;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Deprecated
    public Authenticator getGuard() {
        return this.authenticator;
    }

    public JaxRsRestlet getJaxRsRestlet() {
        return this.jaxRsRestlet;
    }

    public ObjectFactory getObjectFactory() {
        return this.jaxRsRestlet.getObjectFactory();
    }

    public Collection<Class<?>> getRootResources() {
        return this.jaxRsRestlet.getRootResourceClasses();
    }

    public Collection<String> getRootUris() {
        return this.jaxRsRestlet.getRootUris();
    }

    public void setApplications(Collection<javax.ws.rs.core.Application> apps) {
        for (javax.ws.rs.core.Application app : apps) {
            this.add(app);
        }
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.jaxRsRestlet.setContext(context);
    }

    @Deprecated
    public void setGuard(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.jaxRsRestlet.setObjectFactory(objectFactory);
    }
}

