/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal;

import java.util.Iterator;
import org.restlet.data.Reference;
import org.restlet.ext.odata.Query;
import org.restlet.ext.odata.Service;

public class EntryIterator<E>
implements Iterator<E> {
    private Class<?> entityClass;
    private Iterator<E> iterator;
    private Reference nextPage;
    private Service service;

    public EntryIterator(Service service, Iterator<E> iterator, Reference nextPage, Class<?> entityClass) {
        this.iterator = iterator;
        this.nextPage = nextPage;
        this.service = service;
        this.entityClass = entityClass;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.iterator != null) {
            result = this.iterator.hasNext();
        }
        if (!result && this.nextPage != null) {
            Query<?> query = this.service.createQuery(this.nextPage.toString(), this.entityClass);
            this.iterator = query.iterator();
            if (this.iterator != null) {
                result = this.iterator.hasNext();
            }
            this.nextPage = null;
        }
        return result;
    }

    @Override
    public E next() {
        E result = null;
        if (this.iterator != null && this.iterator.hasNext()) {
            result = this.iterator.next();
        }
        return result;
    }

    @Override
    public void remove() {
        if (this.iterator != null) {
            this.iterator.remove();
        }
    }
}

