/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.ntriples;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;

public class RdfNTriplesWriter
extends GraphHandler {
    private BufferedWriter bw;

    public RdfNTriplesWriter(OutputStream outputStream) throws IOException {
        this.bw = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public void endGraph() throws IOException {
        this.bw.flush();
    }

    public void link(Graph source, Reference typeRef, Literal target) {
        Context.getCurrentLogger().warning("Subjects as Graph are not supported in N-Triples.");
    }

    public void link(Graph source, Reference typeRef, Reference target) {
        Context.getCurrentLogger().warning("Subjects as Graph are not supported in N-Triples.");
    }

    public void link(Reference source, Reference typeRef, Literal target) {
        try {
            this.write(source);
            this.bw.write(" ");
            this.write(typeRef);
            this.bw.write(" ");
            this.write(target);
            this.bw.write(".\n");
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }

    public void link(Reference source, Reference typeRef, Reference target) {
        try {
            this.write(source);
            this.bw.write(" ");
            this.write(typeRef);
            this.bw.write(" ");
            this.write(target);
            this.bw.write(".\n");
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }

    private void write(Literal literal) throws IOException {
        this.bw.write("\"");
        this.bw.write(literal.getValue());
        this.bw.write("\"");
    }

    private void write(Reference reference) throws IOException {
        String uri = reference.toString();
        if (Link.isBlankRef(reference)) {
            this.bw.write(uri);
        } else {
            this.bw.append("<");
            this.bw.append(uri);
            this.bw.append(">");
        }
    }
}

