/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.turtle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.internal.RdfConstants;
import org.restlet.ext.rdf.internal.turtle.BlankNodeToken;
import org.restlet.ext.rdf.internal.turtle.Context;
import org.restlet.ext.rdf.internal.turtle.LexicalUnit;
import org.restlet.ext.rdf.internal.turtle.RdfTurtleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListToken
extends LexicalUnit {
    List<LexicalUnit> lexicalUnits = new ArrayList<LexicalUnit>();

    public List<LexicalUnit> getLexicalUnits() {
        return this.lexicalUnits;
    }

    public ListToken(RdfTurtleReader contentHandler, Context context) throws IOException {
        super(contentHandler, context);
        this.parse();
    }

    @Override
    public Object resolve() {
        Reference currentBlankNode = (Reference)new BlankNodeToken(this.getContentReader().newBlankNodeId()).resolve();
        for (LexicalUnit lexicalUnit : this.lexicalUnits) {
            Object element = lexicalUnit.resolve();
            if (element instanceof Reference) {
                this.getContentReader().link(currentBlankNode, RdfConstants.LIST_FIRST, element);
            } else if (element instanceof String) {
                this.getContentReader().link(currentBlankNode, RdfConstants.LIST_FIRST, new Reference((String)element));
            } else {
                org.restlet.Context.getCurrentLogger().warning("The list contains an element which is neither a Reference nor a literal.");
            }
            Reference restBlankNode = (Reference)new BlankNodeToken(this.getContentReader().newBlankNodeId()).resolve();
            this.getContentReader().link(currentBlankNode, RdfConstants.LIST_REST, restBlankNode);
            currentBlankNode = restBlankNode;
        }
        this.getContentReader().link(currentBlankNode, RdfConstants.LIST_REST, RdfConstants.OBJECT_NIL);
        return currentBlankNode;
    }

    @Override
    public String getValue() {
        return this.lexicalUnits.toString();
    }

    @Override
    public void parse() throws IOException {
        this.getContentReader().parseList(this);
    }
}

