/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.turtle;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfConstants;
import org.restlet.ext.rdf.internal.turtle.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdfTurtleWriter
extends GraphHandler {
    private BufferedWriter bw;
    private Context context;
    private Reference precPredicate;
    private Reference precSource;
    private boolean writingExtraDot;

    public RdfTurtleWriter(OutputStream outputStream) throws IOException {
        this.bw = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.context = new Context();
        Map<String, String> prefixes = this.context.getPrefixes();
        prefixes.put(RdfConstants.RDF_SCHEMA.toString(), "rdf");
        prefixes.put(RdfConstants.RDF_SYNTAX.toString(), "rdfs");
        prefixes.put("http://www.w3.org/2000/10/swap/grammar/bnf#", "cfg");
        prefixes.put("http://www.w3.org/2000/10/swap/grammar/n3#", "n3");
        prefixes.put("http://www.w3.org/2000/10/swap/list#", "list");
        prefixes.put("http://www.w3.org/2000/10/swap/pim/doc#", "doc");
        prefixes.put("http://www.w3.org/2002/07/owl#", "owl");
        prefixes.put("http://www.w3.org/2000/10/swap/log#", "log");
        prefixes.put("http://purl.org/dc/elements/1.1/", "dc");
        prefixes.put("http://www.w3.org/2001/XMLSchema#", "type");
        for (String key : prefixes.keySet()) {
            this.bw.append("@prefix ").append(prefixes.get(key)).append(": <").append(key).append(">.\n");
        }
        this.bw.append("@keywords a, is, of, has.\n");
    }

    @Override
    public void endGraph() throws IOException {
        this.bw.write(".\n");
        this.bw.flush();
    }

    @Override
    public void link(Graph source, Reference typeRef, Literal target) {
        try {
            this.writingExtraDot = false;
            this.bw.write("{");
            this.write(source);
            this.bw.write("} ");
            this.write(typeRef, this.context.getPrefixes());
            this.bw.write(" ");
            this.write(target);
            this.precSource = null;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            org.restlet.Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void link(Graph source, Reference typeRef, Reference target) {
        try {
            this.writingExtraDot = false;
            this.bw.write("{");
            this.write(source);
            this.bw.write("} ");
            this.write(typeRef, this.context.getPrefixes());
            this.bw.write(" ");
            this.write(target, this.context.getPrefixes());
            this.precSource = null;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            org.restlet.Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void link(Reference source, Reference typeRef, Literal target) {
        try {
            if (source.equals((Object)this.precSource)) {
                if (typeRef.equals((Object)this.precPredicate)) {
                    this.bw.write(", ");
                } else {
                    this.bw.write("; ");
                    this.write(typeRef, this.context.getPrefixes());
                    this.bw.write(" ");
                }
            } else {
                if (this.writingExtraDot) {
                    this.bw.write(".\n");
                }
                this.write(source, this.context.getPrefixes());
                this.bw.write(" ");
                this.write(typeRef, this.context.getPrefixes());
                this.bw.write(" ");
            }
            this.write(target);
            this.precSource = source;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            org.restlet.Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void link(Reference source, Reference typeRef, Reference target) {
        try {
            if (source.equals((Object)this.precSource)) {
                this.writingExtraDot = false;
                if (typeRef.equals((Object)this.precPredicate)) {
                    this.bw.write(", ");
                } else {
                    this.bw.write("; ");
                    this.write(typeRef, this.context.getPrefixes());
                    this.bw.write(" ");
                }
            } else {
                if (this.writingExtraDot) {
                    this.bw.write(".\n");
                }
                this.write(source, this.context.getPrefixes());
                this.bw.write(" ");
                this.write(typeRef, this.context.getPrefixes());
                this.bw.write(" ");
            }
            this.write(target, this.context.getPrefixes());
            this.precSource = source;
            this.precPredicate = typeRef;
            this.writingExtraDot = true;
        }
        catch (IOException e) {
            org.restlet.Context.getCurrentLogger().warning("Cannot write the representation of a statement due to " + e.getMessage());
        }
    }

    @Override
    public void startGraph() {
    }

    private void write(Graph linkset) throws IOException {
        for (Link link : linkset) {
            if (link.hasReferenceSource()) {
                if (link.hasReferenceTarget()) {
                    this.link(link.getSourceAsReference(), link.getTypeRef(), link.getTargetAsReference());
                } else if (link.hasLiteralTarget()) {
                    this.link(link.getSourceAsReference(), link.getTypeRef(), link.getTargetAsLiteral());
                } else if (!link.hasLinkTarget()) {
                    org.restlet.Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                }
            } else if (link.hasGraphSource()) {
                this.writingExtraDot = false;
                if (link.hasReferenceTarget()) {
                    this.link(link.getSourceAsGraph(), link.getTypeRef(), link.getTargetAsReference());
                } else if (link.hasLiteralTarget()) {
                    this.link(link.getSourceAsGraph(), link.getTypeRef(), link.getTargetAsLiteral());
                } else if (!link.hasLinkTarget()) {
                    org.restlet.Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the object is neither a Reference nor a literal.");
                }
                this.bw.write(".\n");
            }
            this.precSource = link.getSourceAsReference();
            this.precPredicate = link.getTypeRef();
        }
        if (this.writingExtraDot) {
            this.bw.write(".\n");
        }
    }

    private void write(Literal literal) throws IOException {
        this.bw.write("\"");
        if (literal.getValue().contains("\n")) {
            this.bw.write("\"");
            this.bw.write("\"");
            this.bw.write(literal.getValue());
            this.bw.write("\"");
            this.bw.write("\"");
        } else {
            this.bw.write(literal.getValue());
        }
        this.bw.write("\"");
        if (literal.getDatatypeRef() != null) {
            this.bw.write("^^");
            this.write(literal.getDatatypeRef(), this.context.getPrefixes());
        }
        if (literal.getLanguage() != null) {
            this.bw.write("@");
            this.bw.write(literal.getLanguage().toString());
        }
    }

    private void write(Reference reference, Map<String, String> prefixes) throws IOException {
        String uri = reference.toString();
        if (Link.isBlankRef(reference)) {
            this.bw.write(uri);
        } else {
            boolean found = false;
            for (String key : prefixes.keySet()) {
                if (!uri.startsWith(key)) continue;
                found = true;
                this.bw.append(prefixes.get(key));
                this.bw.append(":");
                this.bw.append(uri.substring(key.length()));
                break;
            }
            if (!found) {
                this.bw.append("<");
                this.bw.append(uri);
                this.bw.append(">");
            }
        }
    }
}

