/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.Iterator;
import org.restlet.Context;
import org.restlet.data.Encoding;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.application.DecodeRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;

public class Decoder
extends Filter {
    private volatile boolean decodeRequest;
    private volatile boolean decodeResponse;

    public Decoder(Context context) {
        this(context, true, false);
    }

    public Decoder(Context context, boolean decodeRequest, boolean decodeResponse) {
        super(context);
        this.decodeRequest = decodeRequest;
        this.decodeResponse = decodeResponse;
    }

    public void afterHandle(Request request, Response response) {
        if (this.isDecodeResponse() && this.canDecode(response.getEntity())) {
            response.setEntity(this.decode(response.getEntity()));
        }
    }

    public int beforeHandle(Request request, Response response) {
        if (this.isDecodeRequest() && this.canDecode(request.getEntity())) {
            request.setEntity(this.decode(request.getEntity()));
        }
        return 0;
    }

    public boolean canDecode(Representation representation) {
        boolean result;
        boolean bl = result = representation != null && !representation.getEncodings().isEmpty();
        if (result) {
            boolean found = false;
            Iterator<Encoding> iter = representation.getEncodings().iterator();
            while (!found && iter.hasNext()) {
                found = !iter.next().equals(Encoding.IDENTITY);
            }
            result = found;
        }
        return result;
    }

    public Representation decode(Representation representation) {
        Representation result = representation;
        boolean supported = true;
        boolean identityEncodings = true;
        Iterator<Encoding> iter = representation.getEncodings().iterator();
        while (supported && iter.hasNext()) {
            Encoding encoding = iter.next();
            supported = DecodeRepresentation.getSupportedEncodings().contains(encoding);
            identityEncodings &= encoding.equals(Encoding.IDENTITY);
        }
        if (supported && !identityEncodings) {
            result = new DecodeRepresentation(representation);
        }
        return result;
    }

    public boolean isDecodeRequest() {
        return this.decodeRequest;
    }

    public boolean isDecodeResponse() {
        return this.decodeResponse;
    }

    public void setDecodeRequest(boolean decodeRequest) {
        this.decodeRequest = decodeRequest;
    }

    public void setDecodeResponse(boolean decodeResponse) {
        this.decodeResponse = decodeResponse;
    }
}

